@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><h1><i class="far fa-address-book"></i> {{__('Credit my wallet')}}</h1></div>

                <div class="card-body">
                   <div class="panel panel-primary">
						@if(session()->has('warning'))
                            <div class="alert alert-warning }}"> 
                            {!! session('warning') !!}
                            </div>
                        @endif
                    	<div class="card mb-3">
                    		<div class="card-header"><h3>{{__('My wallet')}}</h3></div>
							<div class="card-body">
							
								<p>{{trans_choice('user.credits',Auth::user()->user_portefeuille_credits)}}</p>
							</div>
						</div>
						<div class="card">
                    		<div class="card-header"><h3>{{__('Buy')}}</h3></div>
							<table class="card-body table">
	                            <thead>
	                                <tr>
	                                    <th>{{__('Name')}}</th>
	                                     <th class="text-right">{{__('payment.unit_price')}}</th>
	                                     <th class="text-right">{{__('payment.page_qty')}}</th>
	                                     <th class="text-right">{{__('payment.req_qty')}}</th>
	                                     <th class="text-right">{{__('payment.duration')}}</th>
	                                     <th class="text-right">{{__('payment.strongbox_qty')}}</th>
	                                     <th class="text-right"></th>
	                                </tr>
	                            </thead>
	                            <tbody>
	                            @foreach ($formulesPaiement as $formule)
	                                    <tr>
	                                        <td class="text-primary"><strong>{{ $formule->libelle }}</strong></td>
	                                        <td class="text-right">{{  number_format($formule->pu,2,',',' ') }}</td>
	                                       <td class="text-right">{{ $formule->nombre_pages }}</td>
	                                         <td><strong>x {{ ceil($nbPagesToOrder/$formule->nombre_pages) }}</strong></td>
	                                       <td class="text-right">{{ $formule->duree_validite }}</td>
	                                       <td class="text-right">{{ $formule->nombre_documents_coffre_fort }}
	                                       <td class="text-right">
	                                       <form method="post" action="{{route('methodPaymentSelect')}}">
	                                       		@csrf
	                                            <input type="hidden" name="formule_id" value="{{ $formule->id }}" />
	                                            <input type="hidden" name="qte_min" value="{{ ceil($nbPagesToOrder/$formule->nombre_pages) }}" />
	                                            <input type="submit" value="{{__('Select')}}" class="btn btn-success btn-block" 
	                                            onclick="return confirm('{{__('payment.confirm_msg',['qty'=> ceil($nbPagesToOrder/$formule->nombre_pages),'lib'=>'"'.$formule->libelle.'"','tot'=>$formule->pu * ceil($nbPagesToOrder/$formule->nombre_pages)])}}')" />
	                                        </form>
											</td>
	                                        </td>
	                                    </tr>
	                                @endforeach
	                            </tbody>
	                        </table>
                    </div>
		        </div>
            </div>
        </div>
    </div>
</div>
@endsection
