<?php $__env->startSection('morecss'); ?>
<style>
<!--
ul li{list-style:none;margin-bottom:0.5em;}
ul.demandes{margin-left:0;padding-left:0}
ul.demandes li:first-child{font-weight:600}
ul.demandes > li:first-child > a:first-child{font-size:x-large;}
ul.demandes li a.dropdown-toggle,ul ul li {font-size:small}
.dropdown-menu.messages{font-size:small}
.flex-item{width:150px;margin-bottom:2em;align-items: center;
    display: flex;
    justify-content: center;}
.flex-item a{text-align:center;color:#6666aa}
.flex-item a:hover{color:#6666ff}
.flex-item i{width:100%;font-size: 120px}
.text-shadow{text-shadow:0 .5rem 1rem rgba(0,0,0,.15)!important }

-->
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><h1>Tableau de bord</h1></div>
				<?php if(session('status')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
    				<ul class="alert alert-warning">
    					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    					<li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    				</ul>
				<?php endif; ?> 
				<?php if(session()->has('message')): ?>
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    <?php echo session('message'); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			<?php endif; ?>
                <div class="card-body">
					<?php if(Auth::user()->prestataire): ?>
                    <h2>Connecté en tant que prestataire</h2>
                    <?php endif; ?>
                    <?php if(Auth::user()->admin): ?>
                        <h2>Connecté en tant qu'admin</h2>
                        <div class="content">
            				<div class="d-flex flex-row flex-wrap justify-content-between">
                				<div class="flex-item">
                					<a href="<?php echo e(route('demandes.index')); ?>">
                					<i class="fas fa-question-circle"></i>
                					Demandes
                					</a>
                				</div>
                				<div class="flex-item">
                					<a href="<?php echo e(route('interventions.index')); ?>">
                					<i class="fas fa-file-contract"></i>
                					Devis
                					</a>
                				</div>
                				<div class="flex-item">
                					<a href="<?php echo e(route('factures.index')); ?>">
                					<i class="fas fa-file-alt"></i>
                					Factures
                					</a>
                				</div>
                				
                				<div class="flex-item">
                				<a href="<?php echo e(route('clients.index')); ?>">
                					<i class="fas fa-users"></i>
                					Clients
                					</a>
                				</div>
                				<div class="flex-item">
                				<a href="<?php echo e(route('prestataires.index')); ?>">
                					<i class="fas fa-tools"></i>
                					Prestataires
                					</a>
                				</div>
                				<div class="flex-item">
                				<a href="<?php echo e(route('assistants.index')); ?>">
                					<i class="fas fa-hands-helping"></i>
                					Assistants
                					</a>
                				</div>
                				<div class="flex-item">
                				<a href="<?php echo e(route('communes.index')); ?>">
                					<i class="fas fa-city"></i>
                					Communes
                					</a>
                				</div>
            				</div>
        				</div>
    				<?php endif; ?>                
                	<?php if(Auth::user()->assistant): ?>
                    	<h2>Connecté en tant qu'assistant</h2>
                    
                    	<h3>Demandes en cours</h3>
                    	<ul class="demandes"><?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $demande): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    	<li><?php echo e($demande->created_at_date); ?> à <?php echo e($demande->created_at_time); ?> : 
                    			<a href="<?php echo e(route('demandes.show',$demande->id)); ?>"><?php echo e($demande->libelle); ?></a> 
                    			par <?php echo e($demande->user->fullname); ?> 
                    	<?php if(count($demande->messages)): ?> 
            				<a class="dropdown-toggle" data-toggle="dropdown" href="#">(<?php echo e(count($demande->messages)); ?> messages dont <?php echo e(count($demande->messages->where('lu','=',null))); ?> non lus)
            				<span class="caret"></span></a>
                    		<div class="dropdown-menu messages">
                        	<?php $__currentLoopData = $demande->messages->where('lu','=',null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    							<a class="dropdown-item" href="<?php echo e(route('demandes.show',$demande->id)); ?>#<?php echo e($message->id); ?>">le <?php echo e($message->created_at_date); ?> à <?php echo e($message->created_at_time); ?> par <?php echo e($message->user->fullname); ?></a>
                        	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                	    	</div>
                    	
                    	<?php endif; ?>
                    	</li>
                    	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    	</ul>
                    	
                	<?php endif; ?>
                	<?php if(Auth::user()->prestataire): ?>
                    	<h2>Mes interventions programmées</h2>
                    	<ul class="demandes">
                    	<?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intervention): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    		<li><a href="<?php echo e(route('interventions.show',$intervention->id)); ?>"><?php echo e($intervention->demande->libelle); ?></a> 
                    		<?php if($intervention->scheduled_at): ?>
                    		<small>programmée le <?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $intervention->scheduled_at)->isoFormat('LLLL')); ?> </small>
                    		<?php endif; ?>
                    		</li>
                    	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    	</ul>
                    <?php endif; ?>
                    
                    <?php if(!(Auth::user()->admin || Auth::user()->assistant || Auth::user()->prestataire)): ?>
                    	<h2><a href="<?php echo e(route('demandes.create')); ?>" class="btn btn-outline-warning btn-lg font-weight-bold bg-warning text-white "><i class="fas fa-comment"></i> <span class="">Faire une demande d'intervention</span></a></h2>
                    	<?php if(count($demandes)): ?>
                        	<h3>Mes demandes</h3>
                        	<ul class="demandes">
                        	<?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $demande): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        	<li><?php echo e($demande->created_at_date); ?> à <?php echo e($demande->created_at_time); ?> : 
                        			<a href="<?php echo e(route('demandes.show',$demande->id)); ?>"><?php echo e($demande->libelle); ?></a> 
                        			par <?php echo e($demande->user->fullname); ?> 
                			<?php if(count($demande->messages)): ?> 
                				<a class="dropdown-toggle" data-toggle="dropdown" href="#">(<?php echo e(count($demande->messages)); ?> messages dont <?php echo e(count($demande->messages->where('lu','=',null))); ?> non lus)
                				<span class="caret"></span></a>
                        		<div class="dropdown-menu messages">
                            	<?php $__currentLoopData = $demande->messages->where('lu','=',null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        							<a class="dropdown-item" href="<?php echo e(route('demandes.show',$demande->id)); ?>#<?php echo e($message->id); ?>">le <?php echo e($message->created_at_date); ?> à <?php echo e($message->created_at_time); ?> par <?php echo e($message->user->fullname); ?></a>
                            	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    	    	</div>
                        	
                        	<?php endif; ?>
                        	</li>
                        	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        	</ul>
                    	<?php endif; ?>
                    <?php endif; ?>
                   <?php if(count($demandes)): ?>
                   <a href="<?php echo e(route('demandes.index')); ?>">voir toutes</a>
                   <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/hellodjo/resources/views/home.blade.php ENDPATH**/ ?>