<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLigneDemandesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ligne_demandes', function (Blueprint $table) {
            $table->uuid('id')
                  ->primary();
            $table->string('libelle')
                  ->nullable(true);
            $table->double('montant_ht',8,2)
                  ->nullable(true);
            $table->double('taux_tva',8,2)
                  ->nullable(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ligne_demandes');
    }
}
