<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDemandesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('demandes', function (Blueprint $table) {
            $table->uuid('id')
                  ->primary();
            $table->string('num_facture')
                  ->nullable(true);
            $table->string('libelle')
                  ->nullable(true);
            $table->boolean('facture')
                  ->nullable(true);
            $table->dateTime('date_facture')
                  ->nullable(true);
            $table->double('total_ht',8,2)
                  ->nullable(true);
            $table->double('total_ttc',8,2)
                  ->nullable(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('demandes');
    }
}
