<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSocietesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('societes', function (Blueprint $table) {
            $table->uuid('id')
                  ->primary();
            $table->string('raison_sociale',191)
                  ->nullable(true);
            $table->string('siret',20)
                  ->nullable(true);
            $table->longText('adresse',250)
                  ->nullable(true);
            $table->string('code_postal',5)
                  ->nullable(true);
            $table->string('commune',150)
                  ->nullable(true);
            $table->double('tarif_prestation_ht')
                  ->nullable(true);
            $table->uuid('tva_id')
                  ->nullable(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('societes');
    }
}
