<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Traits\UsesUuid;

// class User extends Authenticatable implements MustVerifyEmail
class User extends Authenticatable
{
    use Notifiable,UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id', 'name','surname','email','telephone',
        'siret','societe',
        'admin', 'assistant', 'prestataire', 'password',
        'email_uniskip','motdepasse_uniskip'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    
    public function adresses()
    {
        // Relation 1..n
        return $this->hasMany(Adresse::class);
    }
    
    public function demandes()
    {
        // Relation 1..n
        return $this->hasMany(Demande::class);
    }

    public function interventions()
    {
        // Relation 1..n
        return $this->hasMany(Intervention::class);
    }
    
    public function messages()
    {
        // Relation 1..n
        return $this->hasMany(Message::class);
    }
    
    public function getFullnameattribute(){
        return $this->surname.' '.$this->name;
    }
    public function isClient(){
        return (!$this->admin && !$this->assistant && !$this->prestataire);
    }
    public function isAdmin(){
        return $this->admin;
    }
}
