<?php namespace App\Repositories;

use App\User;
use Illuminate\Http\Request;

class UserRepository extends BaseRepository
{
	   
    public function __construct(User $user)
	{
		$this->model = $user;
	}
	
	public function restrictType($type){
	    switch($type){
	        case 'assistant':$this->model = $this->model->where('assistant','=',1);
	        break;
	        case "prestataire":$this->model = $this->model->where('prestataire','=',1);
	        break;
	        case "admin":$this->model = $this->model->where('admin','=',1);
	        break;
	    }
	}
	
	public function getPaginate($n,$request=null)
	{
	    if ($request->nom)
	        return $this->model->where('name','like','%'.$request->nom.'%')
                    ->orWhere('surname','like','%'.$request->nom.'%')
                    ->latest()->paginate($n);
        else 
            return $this->model->latest()->paginate($n);
	}
}