<?php

namespace App\Http\Controllers;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Demande;
use Carbon\Carbon;
use App\Intervention;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('verified');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        //Carbon::setUTF8(true);
        Carbon::setLocale(config('app.locale'));
        setlocale(LC_ALL, 'fr_FR.UTF-8');// Ne fonctionne pas en local mais c'est ...normal :/ fonctionne sur ubuntu
        
        //$demandes = Demande::with('messages.user')->orderby('created_at','desc')->get();
        //DB::connection()->enableQueryLog();
        if (auth()->user()->assistant=='1')
            $demandes = Demande::whereNotNull('user_id')->orderby('created_at','desc')->take(15)->get();
            else
                if (auth()->user()->prestataire=='1')
                    $demandes = auth()->user()->interventions()->with('demande')//,'demande.statuts')
                                    ->whereNotNull('scheduled_at')
                                    //->whereDate('scheduled_at','>=',Carbon::today()->toDateString())
                                    ->whereDoesntHave('demande.statuts', function (Builder $query) {
                                        $query->where('id','=','SOLDEE');
                                    })
                                    ->orderby('scheduled_at','asc')
                                    ->orderby('created_at','desc')
                                    ->take(15)->get(); 
                //Demande::with('interventions')->where('user_id','=',auth()->id())->orderby('created_at','desc')->get();
                    else 
                        $demandes = auth()->user()->demandes()->orderby('created_at','desc')->take(15)->get();
                
       //print_r(DB::connection()->getQueryLog());
                      
        return view('home',compact('demandes'));
        //return redirect(route('demandes.create'));
    }
}
