<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Societe;
use App\Tva;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class AdminController extends Controller
{
    //
    
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('verified');
    }
    
    public function editConfig(){
        $societe = Societe::first();
        $tvas = Tva::all();
        return view('admin.config',compact('societe','tvas'));
    }
   public function rules()
    {
        return [
            'raison_sociale' => 'required|max:255',
            'enseigne' => 'max:191',
            'siret' => 'required|max:255',
            'adresse' => 'required|max:255',
            'code_postal' => 'required|max:8',
            'commune' => 'required|max:255',
            'tarif_prestation_ht' =>"required|numeric",
            'tva_id' => 'required:max:36',
            'tva_travaux_id' => 'required:max:36',
            //
        ];
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updateConfig(Request $request)
    {
        $request->flash();
           
        if (!$this->validate($request, $this->rules())){
           return redirect(route('users.edit'))->withInput();
        }
        $inputs = $request->all();
        DB::connection()->enableQueryLog();
        $societe = Societe::where('id','=','1');
        $societe->update($request->except(['_token','_method','submit']));
        return redirect(route('home'))->with('message',"Vos informations ont été modifiées");
    }
    
    public function changeBanniere(Request $request){
        $request->flash();
        if (!$this->validate($request, ['banniere'=> 'required|mimes:gif'])){
            return redirect(route('config.edit'))->with('message',"La bannière doit être au format gif");
        }
        $file = $request->file('banniere');
        //dd(Storage::disk('public'));
        Storage::disk('publicimages')->put('banniere.gif', file_get_contents($file));
        return redirect(route('home'))->with('message',"La bannière a été remplacée");
    }
}
