<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Commune extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'nom',
        'code_postal',
        'tarif',
        'tva_id'
    ];

    public function tva()
    {
        // Relation 1..n
        return $this->belongsTo(Tva::class);
    }

    public function adresses()
    {
        // Relation 1..n
        return $this->hasMany(Adresse::class);
    }
}
