@extends('layouts.app')
@section('morejs')
<script type="text/javascript">

function removeAdresse(adrId,adrName){
	if (document.getElementById(adrId).checked==true)
		alert("impossible de supprimer l'adresse par défaut")
	else
	if (confirm("Cette adresse sera supprimée lors de l'enregistrement. Confirmer ?")){
		document.getElementById('adr_'+adrId).innerHTML = '<span class="text-warning">'+adrName + ' à supprimer</span>';
		document.getElementById('s_'+adrId).value=adrId;
	}
}
//
</script>
@endsection
@section('morecss')
<style>
.flex-item{width:120px}
</style>
@endsection 
@section('content')
<div class="container">
	<div class="justify-content-center">
		<div class="">
			<div class="card">
				<div class="card-header">
					@if (Auth::id()==$user->id)
							<h1>Mon compte</h1>
							@else
							<h1>Modifier {{$user->full_name}}</h1>
							@endif
							
				</div>
				<div class="card-body">
					@if ($user->prestataire)
					<p>&Eacute;valuation moyenne : {{$scoring_calcule}}</p>
					@endif
					<form method="post" action="{{$route}}">
						{{ csrf_field() }} 
						{{ method_field('patch') }}
						<fieldset>
							@if (Auth::id()==$user->id)
							<legend>Mes informations</legend>
							@else
							<legend>Informations</legend>
							@endif
							<div class="form-group row">
								<label for="name" class="col-md-4 col-form-label text-md-right">{{__('Name') }}</label>

								<div class="col-md-6">
									<input id="name" type="text"
										class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}"
										name="name" value="{{ $user->name }}" required autofocus>
										@if ($errors->has('name')) 
											<span class="invalid-feedback" role="alert"> <strong>{{ $errors->first('name') }}</strong>
										</span> 
										@endif
								</div>
							</div>

							<div class="form-group row">
								<label for="surname"
									class="col-md-4 col-form-label text-md-right">{{ __('Surname')
									}}</label>

								<div class="col-md-6">
									<input id="surname" type="text"
										class="form-control{{ $errors->has('surname') ? ' is-invalid' : '' }}"
										name="surname" value="{{ $user->surname }}" required autofocus>

									@if ($errors->has('surname')) <span class="invalid-feedback"
										role="alert"> <strong>{{ $errors->first('surname') }}</strong>
									</span> @endif
								</div>
							</div>

							<div class="form-group row">
								<label for="email" class="col-md-4 col-form-label text-md-right">{{
									__('E-Mail Address') }}</label>

								<div class="col-md-6">
									<input id="email" type="email"
										class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
										name="email" value="{{ $user->email }}" required>
										@if ($errors->has('email')) 
										<span class="invalid-feedback"
										role="alert"> <strong>{{ $errors->first('email') }}</strong>
										</span>
										@endif
								</div>
							</div>
							
							<div class="form-group row">
								<label for="telephone"
									class="col-md-4 col-form-label text-md-right">{{ __('Téléphone')
									}}</label>

								<div class="col-md-6">
									<input id="telephone" type="text"
										class="form-control{{ $errors->has('telephone') ? ' is-invalid' : '' }}"
										name="telephone" value="{{ $user->telephone}}" required autofocus>

									@if ($errors->has('telephone')) <span class="invalid-feedback"
										role="alert"> <strong>{{ $errors->first('telephone') }}</strong>
									</span> @endif
								</div>
							</div>
						</fieldset>
						@if (Auth::user()->isClient())
						<fieldset>
							<legend><i class="fas fa-building"></i> Mon entreprise</legend>
							<div class="form-group row">
								<label for="societe" class="col-md-4 col-form-label text-md-right">Raison sociale</label>

								<div class="col-md-6">
									<input id="societe" type="text"
										class="form-control{{ $errors->has('societe') ? ' is-invalid' : '' }}"
										name="societe" value="{{ $user->societe }}" >
										@if ($errors->has('societe')) 
											<span class="invalid-feedback" role="alert"> <strong>{{ $errors->first('societe') }}</strong>
										</span> 
										@endif
								</div>
							</div>
							<div class="form-group row">
								<label for="siret" class="col-md-4 col-form-label text-md-right">Siret</label>
								
								<div class="col-md-6">
									<input id="siret" type="text"
										class="form-control{{ $errors->has('siret') ? ' is-invalid' : '' }}"
										name="siret" value="{{ $user->siret }}" >
										@if ($errors->has('siret')) 
											<span class="invalid-feedback" role="alert"> <strong>{{ $errors->first('siret') }}</strong>
										</span> 
										@endif
								</div>
							</div>
						</fieldset>
						<fieldset>
							<legend><i class="fas fa-home"></i> Mes adresses</legend>
							<div class="form-group">
								@if (count($adresses) > 0)
								<small>Mon adresse de facturation par défaut</small>
									<div class="d-flex flex-row flex-wrap align-content-around form-group row col-12">
    									@foreach ($adresses as $adresse)
                                    	<div class="form-check col-3 mb-2" id="adr_{{$adresse->id}}">
                                    
                                    	<input class="form-check-input" type="radio" name="adresse_pardefaut_id" id="{{$adresse->id}}" value="{{$adresse->id}}"
                                    	 @if($adresse->id==old('adresse_pardefaut_id') || $adresse->par_defaut) checked
    										@endif />
                                          <label class="form-check-label" for="{{$adresse->id}}">
                                            {{$adresse->libelle}}
                                          </label>
                                          <div class="bg-white position-absolute" style="top:0;right:1em">
                                          	<a class="px-1 py-0 btn btn-primary" href="{{route('adresses.edit',$adresse->id)}}" ><i class="fas fa-edit"></i></a>
                                          	@if (!App\Demande::where('adresse_id','=',$adresse->id)->exists())
                                          	<a class="px-1 py-0 btn btn-danger" href="#" onclick="removeAdresse('{{$adresse->id}}','{{$adresse->libelle}}')"><i class="fas fa-trash-alt"></i></a>
                                          	@endif
                                          </div>
    									</div>
    									<input name="adresses_supprimees[]" type="hidden" id="s_{{$adresse->id}}" value=""/>
    									@endforeach

								@endif
								<a href="{{route('adresses.create')}}" class="btn px-1 py-0 btn-info"><i class="fas fa-plus-square"></i> Nouvelle adresse</a>
							</div>
						</fieldset>
						@endif
						@if (Auth::user()->isAdmin() && Auth::id()==$user->id )
						{{-- Si c'est la fiche de l'admin lui même qui est affichée --}}
    					<fieldset>
							<legend><i class="fas fa-building"></i> Mon entreprise</legend>
							<p>Raison sociale : {{$societe->raison_sociale}}<br/>
							Siret : {{$societe->siret}}
							</p>
							<p><a href="{{route('config.edit')}}">Modifier les informations <strong><em>{{$societe->raison_sociale}}</em></strong></a></p>
						</fieldset>	
						@endif
						@if (Auth::user()->isAdmin())
						<fieldset>
							<legend>
								<i class="fas fa-tag"></i> Profil
							</legend>
							<div class="d-flex flex-row flex-wrap justify-content-between form-group">
    							<div class="alert alert-danger">
    								<label class="" for="admin">Administrateur</label> 
    								<input id="admin"
    								name="admin" class="form-control form-control-lg" type="checkbox"
    								@if ($user->admin == 1)
    								checked="checked"
    								@endif
    								/>
    							</div>
    							<div class="">
    								<label class="" for="assistant">Assistant</label> 
    								<input id="assistant"
    								name="assistant" class="form-control form-control-lg" type="checkbox"
    								@if ($user->assistant) == 1)
    								checked="checked"
    								@endif
    								/>
    							</div>
    							<div class="">
    								<label class="" for="prestataire">Prestataire</label> 
    								<input id="prestataire"
    								name="prestataire" class="form-control form-control-lg" type="checkbox"
    								@if ($user->prestataire) == 1)
    								checked="checked"
    								@endif
    								/>
    							</div>
    						</div>
						</fieldset>
                        @endif
						
						@if (Auth::user()->id==$user->id)
						<fieldset>
							<legend>{{__('Change my password')}}</legend>
							<div class="form-group row">
								<label for="password-old"
									class="col-md-4 col-form-label text-md-right">{{ __('Old password') }}</label>

								<div class="col-md-6">
									<input id="password-old" type="password"
										class="form-control{{ $errors->has('password-old') ? ' is-invalid' : '' }}"
										name="password-old"> @if ($errors->has('password-old')) <span
										class="invalid-feedback" role="alert"> <strong>{{ __('failed')
											}}</strong>
									</span> @endif
								</div>
							</div>
							<div class="form-group row">
								<label for="password"
									class="col-md-4 col-form-label text-md-right">{{ __('New password') }}</label>

								<div class="col-md-6">
									<input id="password" type="password"
										class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
										name="password"> @if ($errors->has('password')) <span
										class="invalid-feedback" role="alert"> <strong>{{
											$errors->first('password') }}</strong>
									</span> @endif
								</div>
							</div>

							<div class="form-group row">
								<label for="password-confirm"
									class="col-md-4 col-form-label text-md-right">{{ __('Confirm password') }}</label>

								<div class="col-md-6">
									<input id="password-confirm" type="password"
										class="form-control" name="password_confirmation">
								</div>
							</div>

						</fieldset>
						@endif
						<div class="form-group row mb-0">
							<div class="col">
								<a href="javascript:history.back()" class="btn btn-primary"> <span
									class="glyphicon glyphicon-circle-arrow-left"></span>
									{{__('Cancel')}}
								</a>
							</div>
							<div class="col">
								<button type="submit" class="btn btn-primary">{{ __('Update') }}
								</button>
							</div>
						</div>
					</form>
				</div>
				<div class="card-footer">
					<a href="{{route('home')}}" class="btn">Retour à l'accueil</a>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
