<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPcentAcompteToDemandesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('demandes', function (Blueprint $table) {
            $table->integer('pcent_acompte', false,true)
            ->after('total_ttc')
            ->nullable(true);
            $table->double('montant_verse',8,2)
            ->after('total_ttc')
            ->default(0);
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('demandes', function (Blueprint $table) {
            $table->dropColumn(['pcent_acompte']);
            $table->dropColumn(['montant_verse']);
        });
    }
}
