<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Paiement extends Model
{
    use UsesUuid;
    public $incrementing = false;
    protected $fillable = [
        'id',
        'montant',
        'mode_paiement_id',
        'transaction_id',
        'date_paiement',
        'demande_id'
    ];
    
    public function demande()
    {
        // Relation 1..n
        return $this->belongsTo(Demande::class);
    }
    public function modePaiement()
    {
        // Relation 1..n
        return $this->belongsTo(ModePaiement::class);
    }
}
