<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Events\MessageCreated;
use App\Traits\UsesUuid;
use Carbon\Carbon;

class Message extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'text',
        'lu',
        'rapport_flag',
        'inemail_flag',
        'user_id'
    ];
    
    protected $dispatchesEvents = [
        'created' => MessageCreated::class,
    ];

    public function user()
    {
        // Relation 1..n
        return $this->belongsTo(User::class);
    }

    public function demande()
    {
        // Relation 1..n
        return $this->belongsTo(Demande::class);
    }

    public function documents()
    {
        // Relation n..n
        return $this->belongsToMany(Document::class);
    }
    public function getCreatedAtDateAttribute(){
        //return $this->created_at->formatLocalized('%d %B %Y');
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at,'UTC')->timezone('America/Martinique')->formatLocalized('%d %B %Y');
    }
    public function getCreatedAtTimeAttribute(){
        //return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('H:i');
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at,'UTC')->timezone('America/Martinique')->format('H:i');
    }
}
