<?php

namespace App\Http\Controllers;

use App\Document;
use App\Societe;
use App\User;
use App\Repositories\InterventionRepository;
use Illuminate\Http\Request;
use App\Demande;
use App\Ligne_demande;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class InterventionController extends Controller
{
    
    protected $interventionRepository;
    public function __construct(InterventionRepository $interventionRepository)
    {
        $this->interventionRepository = $interventionRepository;
        $this->middleware('auth');
        $this->middleware('verified');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        
        Carbon::setLocale(config('app.locale'));
        setlocale(LC_ALL, 'fr_FR.UTF-8');// Ne fonctionne pas en local mais c'est ...normal :/ fonctionne sur ubuntu
        
        
        $interventions = $this->interventionRepository->getPaginate(5,$request);
        
        if($request->datedeb || $request->datefin)
            $interventions = $interventions->appends(["datedeb"=>$request->datedeb,"datefin"=>$request->datefin]);
            
        //$demandes = Demande::with('messages.user')->orderby('created_at','desc')->get();
        
        return view('interventions.index', compact('interventions'));
        
                
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($demandeId)
    {
        if (!Auth::user()->assistant)
            return redirect(route('home'))->with('message','pb de droits');
        //
        $prestataires = User::where('prestataire','=',1)->get();
        if (!$prestataires->count())
            return redirect(route('home'))->withErrors(['message'=>'Aucun prestataire enregistré']);
        $demande = Demande::find($demandeId);
        $montant_amo_ht = Societe::first()->tarif_prestation_ht;
        return view('interventions.create',
            compact('prestataires','demande','montant_amo_ht'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Auth::user()->assistant)
            return redirect(route('home'))->with('message','pb de droits');
            
        //
        $request->flash();
        if (!$this->validate($request, [
            "descriptif"       => 'required|min:3|max:4000',
            'montant_prestation_ht' => 'numeric:required',
            'demande_id' => 'max:191',
            'user_id' => 'max:191',
            'pcent_acompte'=> 'integer|min:10|max:90'
        ]))
            return redirect(route('interventions.create'))->withInput();
        
        $inputs = array_merge($request->all());
        $demande_id = $inputs['demande_id'];
        $demande = Demande::find($demande_id);
        
        if ($demande->intervention()->exists())
            return redirect(route('interventions.edit',$demande->intervention()->first()->id))->with('message','Une intervention existe déjà pour cette demande');
        
        
        $demande->update(['pcent_acompte'=>$inputs['pcent_acompte']]);
        unset($inputs['pcent_acompte']);
        $intervention = $this->interventionRepository->store($inputs);
        
        //création des lignes de demande pour devis
        $tva = Societe::first()->tva;
        $tva_travaux = Societe::first()->tva_travaux;
        
        $demande->ligne_demandes()->delete();
        
        $montant_amo = (isset($inputs['montant_amo_ht']) && is_numeric($inputs['montant_amo_ht']))
                        ?$inputs['montant_amo_ht']
                        :Societe::first()->tarif_prestation_ht;
        
        $montant_amo = round($montant_amo,2);
                        
        $montant_dep = $intervention->demande->adresse->commune->tarif;
        
        $ligneDemande = $demande->ligne_demandes()->createMany([
            [
                'libelle'=>'Frais administratifs',
                'montant_ht' => $montant_amo,
                'taux_tva' => $tva->taux,
                //'demande_id' => $demande_id,
                'tva_id' => $tva->id
            ],
            [
                'libelle'=>'Déplacement commune : '.$demande->adresse->commune->nom,
                'montant_ht' =>  $montant_dep,
                'taux_tva' => $demande->adresse->commune->tva->taux,
                'tva_id' => $demande->adresse->commune->tva_id
            ],
            [
                'libelle'=>'Intervention prestataire',
                'montant_ht' => $inputs['montant_prestation_ht'],
                'taux_tva' => $tva_travaux->taux,
                'tva_id' => $tva_travaux->id
            ]
        ]
        );
        
        
        if (!$demande->statuts()->where('statut_id','=','DEVISEE')->exists())
            $demande->statuts()->attach(['statut_id'=>'DEVISEE']);
        
        //on crée un message automatique pour le client
        $message = $demande->messages()->create(['user_id'=>Auth::id(),
            'text' => "Un devis vous a été envoyé. Merci de prendre connaissance de son contenu ci-après :\n".
                    $inputs['descriptif']."\n".
                    "1. Intervention : \n".
                    "Montant HT : ".$inputs['montant_prestation_ht']." €\n".
                    "2. Déplacement"."\n".
                    "Montant HT : ". $montant_dep." €\n".
                    "3. Frais administratifs"."\n".
                    "Montant HT : ".$montant_amo." €\n"
        ]);
        
        if ($request->hasFile('descriptif_detaillé')){
            $fichier = $request->file('descriptif_detaillé');
            $message->text .= "\nUn descriptif détaillé est joint à ce message";
            $message->save();
            /* $name=$file->getClientOriginalName();
            
            $file->move(public_path().'/files/', $name);
            
            $data[] = $name;*/
            
            $path = basename($fichier->store('documents'));
            $document = Document::create([
                "libelle" => $fichier->getClientOriginalName(),//'message_' . $message->id,
                "nom_fichier" => $path,//$fichier->getClientOriginalName(),
                "url" => '',
                "type_mime" => $fichier->clientExtension()
            ]);
            
            $message->documents()->attach($document->id);
        }
        
        return redirect (route('demandes.show',$intervention->demande_id))->with('message','Devis enregistré.  Une notification a été envoyée au client');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        //
        $intervention = $this->interventionRepository->getById($id);
        $prestataires = User::where('prestataire','=',1)->get();
        $montant_amo_ht = Societe::first()->tarif_prestation_ht;
        
        return view('interventions.show',
            compact('intervention','prestataires','montant_amo_ht'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Auth::user()->assistant)
            return redirect(route('home'))->with('message','pb de droits');
        //
        
        $intervention = $this->interventionRepository->getById($id);
        
        if ($intervention->demande->statuts()->where('statut_id','=','EN_PAIEMENT')->exists())
            return redirect(route('demandes.show',$intervention->demande->id))->withErrors(['message'=>'Le devis a déjà été validé par le client. Impossible de le modifier']);
            
        
        $prestataires = User::where('prestataire','=',1)->get();
        $montant_amo_ht = Societe::first()->tarif_prestation_ht;
        
        
        return view('interventions.edit',
            compact('intervention','prestataires','montant_amo_ht'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $request->flash();
        if (!$this->validate($request, [
            "descriptif"       => 'required|min:3|max:4000',
            'montant_prestation_ht' => 'required',
            'user_id' => 'max:191',
            'pcent_acompte'=> 'integer|min:10|max:90'
        ]))
            return redirect(route('interventions.edit'))->withInput();
        
            
        $this->interventionRepository->getById($id)->demande->update(['pcent_acompte'=>$request->pcent_acompte]);
        
        
        $inputs = array_merge($request->except('pcent_acompte'));
            
        $intervention = $this->interventionRepository->update($id, $inputs);
        $demande_id = $intervention->demande_id;
        
        //création des lignes de demande pour devis
        $demande = Demande::find($demande_id);
        $tva = Societe::first()->tva;
        $tva_travaux = Societe::first()->tva_travaux;
        
        $demande->ligne_demandes()->delete();
        $montant_amo = (isset($inputs['montant_amo_ht']) && is_numeric($inputs['montant_amo_ht']))
                        ?$inputs['montant_amo_ht']
                        :Societe::first()->tarif_prestation_ht;
        
        $montant_amo = round($montant_amo,2);
                        
                        
        $montant_dep = $intervention->demande->adresse->commune->tarif;
        
        $ligneDemande = $demande->ligne_demandes()->createMany([
            [
                'libelle'=>'Frais administratifs',
                'montant_ht' => $montant_amo,
                'taux_tva' => $tva->taux,
                //'demande_id' => $demande_id,
                'tva_id' => $tva->id
            ],
            [
                'libelle'=>'Déplacement commune : '.$demande->adresse->commune->nom,
                'montant_ht' => $montant_dep,
                'taux_tva' => $demande->adresse->commune->tva->taux,
                'tva_id' => $demande->adresse->commune->tva_id
            ],
            [
                'libelle'=>'Intervention prestataire',
                'montant_ht' => $inputs['montant_prestation_ht'],
                'taux_tva' => $tva_travaux->taux,
                'tva_id' => $tva_travaux->id
            ]
        ]
            );
        
        //on crée un message automatique pour le client
        $message = $demande->messages()->create(['user_id'=>Auth::id(),
            'text' => "Le devis a été modifié. Merci de prendre connaissance de son contenu ci-après :\n".
            $inputs['descriptif']."\n".
            "1. Intervention : \n".
            "Montant HT : ".$inputs['montant_prestation_ht']." €\n".
            "2.Déplacement"."\n".
            "Montant HT : ".$montant_dep." €\n".
            "3.Frais administratifs"."\n".
            "Montant HT : ".$montant_amo." €\n"
        ]);
        
        
        if ($request->hasFile('descriptif_detaillé')){
            $fichier = $request->file('descriptif_detaillé');
            $message->text .= "\nUn descriptif détaillé est joint à ce message";
            $message->save();
            /* $name=$file->getClientOriginalName();
            
            $file->move(public_path().'/files/', $name);
            
            $data[] = $name;*/
            
            $path = basename($fichier->store('documents'));
            $document = Document::create([
                "libelle" => $fichier->getClientOriginalName(),//'message_' . $message->id,
                "nom_fichier" => $path,//$fichier->getClientOriginalName(),
                "url" => '',
                "type_mime" => $fichier->clientExtension()
            ]);
            
            $message->documents()->attach($document->id);
        }
        
        
        
        if (!$demande->statuts()->where('statut_id','=','DEVISEE')->exists())
            $demande->statuts()->attach(['statut_id'=>'DEVISEE']);
        
        return redirect (route('demandes.show',$demande_id))->with('message','Devis enregistré.  Une notifaction a été envoyée au client');
    }
    
    
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */ 
    public function destroy($id)
    {
        //
    }
}
