<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\CommuneRepository;
use App\Tva;
use App\Adresse;
use App\Commune;

class CommuneController extends Controller
{
    protected $communeRepository;
    
    protected $nbrPerPage = 4;
    
    protected $validationRules = [
        'id' => 'max:191',
        'nom' => 'required|max:191',
        'code_postal' => 'max:8',
        'tarif' => 'required:numeric',
        'tva_id' => 'required:max:36'
    ];
    
    public function __construct(CommuneRepository $communeRepository)
    {
        $this->communeRepository = $communeRepository;
        $this->middleware('auth');
        $this->middleware('verified');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $communes = $this->communeRepository->getPaginate(15);
        return view('communes.index', compact('communes'));
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $tvas = Tva::all();
        
        return view('communes.create',compact('tvas'));
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->flash();
        if (!$this->validate($request, $this->validationRules))
            return redirect(route('communes.create'))->withInput();
            
            $cat= $this->communeRepository->store($request->all());
            return redirect(route('communes.index'))->with('message',"La commune ". $cat->libelle . " a été créée");
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $commune = $this->communeRepository->getById($id);
        $tvas = Tva::all();
        //
        return view('communes.edit',  compact('commune','tvas'));
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        if (! $this->validate($request, $this->validationRules))
            return $this->edit($id);
            
            $ok = $this->communeRepository->update($id, $request->all());
            return redirect(route('communes.index'))->with("message","La commune a été modifiée.");
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        //
        $commune = Commune::find($id);
        if (!$commune->adresses()->count()){
             $commune->delete();
            return redirect(route('communes.index'))->with(['message' => "La commune" . $commune->libelle." a été supprimée"]);
        } else
            return redirect(route('communes.index'))->with(['message' => "Impossible de supprimer la commune ! Des adresses sont liées"]);
    }
}
