<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Commune;
use App\Repositories\AdresseRepository;
use Illuminate\Support\Facades\Auth;
use App\Adresse;

class AdresseController extends Controller
{
    protected $adresseRepository;
    public function __construct(AdresseRepository $adresseRepository)
    {
        $this->adresseRepository = $adresseRepository;
        $this->middleware('auth');
        $this->middleware('verified');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $communes = Commune::all();
        $from = request()->from;
        return view('adresses.create',
            compact('communes','from'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        //
        $moreInputs = [
            'user_id' => Auth::id(),
        ];
        
        if (Auth::user()->adresses->count()==0)
            $moreInputs['par_defaut'] = true;
        
        $request->flash();
        if (!$this->validate($request, [
            "libelle"       => 'required|max:191',
            'adresse'   => 'max:191',
            'commune_id' => 'max:191',
        ]))
            return redirect(route('adresses.create'))->withInput();
        
        $inputs = array_merge($request->except('from'),$moreInputs);
        
        $adresse = $this->adresseRepository->store($inputs);
        if ($request->input('from')=='demande')
            return redirect(route('demandes.create'))->with(['message'=>"L'adresse " . $adresse->libelle ." a été créée",'new_adresse_id'=>$adresse->id]);
        else
            return redirect(route('users.edit',Auth::id()))->with(['message'=>"L'adresse " . $adresse->libelle ." a été créée",'new_adresse_id'=>$adresse->id]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $adresse = $this->adresseRepository->getById($id);
        $communes = Commune::all();
        return view('adresses.edit',
            compact('communes','adresse'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $request->flash();
        if (!$this->validate($request, [
            "libelle"       => 'required|max:191',
            'adresse'   => 'max:191',
            'commune_id' => 'max:191',
        ]))
            return redirect(route('adresses.edit'))->withInput();
            
            $inputs = $request->except('from');
            /*$inputs = array_merge($request->except('from'),
                [
                    'user_id' => Auth::id()
                ]);
            */
            $adresse = $this->adresseRepository->update($id,$inputs);
            return redirect(route('users.edit',Auth::id()))->with(['message'=>"L'adresse " . $adresse->libelle ." a été modifiée",'new_adresse_id'=>$adresse->id]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
