@extends('layouts.app')
@section('morejs')
<script type="text/javascript">

function removeAdresse(adrId,adrName){
	if (document.getElementById(adrId).checked==true)
		alert("impossible de supprimer l'adresse par défaut")
	else
	if (confirm("Cette adresse sera supprimée lors de l'enregistrement. Confirmer ?")){
		document.getElementById('adr_'+adrId).innerHTML = '<span class="text-warning">'+adrName + ' à supprimer</span>';
		document.getElementById('s_'+adrId).value=adrId;
	}
}
//
</script>
@endsection
@section('morecss')
<style>
.flex-item{width:120px}
</style>
@endsection 
@section('content')
<div class="container">
	<div class="justify-content-center">
		<div class="">
			<div class="card">
				<div class="card-header">
					@if (Auth::id()==$user->id)
							<h1>Mon compte</h1>
							@else
							<h1>{{$user->full_name}}</h1>
							@endif
							
				</div>
				<div class="card-body">
					@if ($user->prestataire)
					<p>&Eacute;valuation moyenne : {{$scoring_calcule}}</p>
					@endif
						@if (Auth::id()==$user->id)
						<h2>Mes informations</h2>
						@else
						<h2>Informations</h2>
						@endif
						<p>{{ $user->fullname }} ({{ $user->email }})</p>
						<h4 class="text-secondary">Téléphone : {{$user->telephone}}</h4>
						@if ($user->isClient() && $user->societe)
							<h2><i class="fas fa-building"></i> Mon entreprise</h2>
							<p>{{ $user->societe }}</p>
							<p>{{ $user->siret }}</p>
							<h2>Mes adresses</h2>
							@if (count($adresses) > 0)
								<div class="d-flex flex-row flex-wrap align-content-around form-group row col-12">
									@foreach ($adresses as $adresse)
                                	<a class="px-1 py-0 btn btn-primary" href="{{route('adresses.edit',$adresse->id)}}" >{{$adresse->libelle}}
                                      <i class="fas fa-edit"></i></a>
									@endforeach
								</div>
							@endif
						@endif
						@if (Auth::user()->isAdmin() && Auth::id()==$user->id )
						{{-- Si c'est la fiche de l'admin lui même qui est affichée --}}
    					<h2>Mon entreprise</h2>
							<p>Raison sociale : {{$societe->raison_sociale}}<br/>
							Siret : {{$societe->siret}}
							</p>
						@endif
						<h3>Adresses</h4>@foreach($user->adresses as $adresse)
						<h4 class="small font-weight-bold">{{$adresse->adresse}} - {{$adresse->commune->nom}}</h4>
						@endforeach
						<a class="btn btn-info mb-4" href="{{route('users.edit',$user->id)}}">Modifier {{$user->fullname}}</a>
						@if(count($demandes) >0)
    						<h2>Demandes</h2>
    						<table class="table">
    				        <thead>
    				            <tr>
    				               <th>Date</th>
    				                <th>Titre</th>
    				                <th>Statut</th>
    				                @if(!Auth::user()->isClient())
    				                <th>Auteur</th>
    				                @endif
    				                <th>Messages</th>
    				        </thead>
    				        <tbody>
    				        @foreach($demandes as $demande)
    				            <tr 
    			                @if ($demande->current_status_id=='PAYEE' && (\Carbon\Carbon::now()->diffInDays($demande->created_at_date_object)<7)) class="table-warning"
    			                @elseif ($demande->current_status_id=='PAYEE') class="table-danger" 
    			                	@endif>
    			                	<td>{{$demande->created_at_date}} à {{$demande->created_at_time}}</td>
    			                    <td class="text-primary">
    			                    	<strong><a href="{{route('demandes.show',$demande->id)}}">{{$demande->libelle}}</a></strong>
    			                    </td>
    			                    <td>@if ($demande->current_status) {{$demande->current_status->libelle}} @endif</td>
    			                    @if(!Auth::user()->isClient())
    			                    <td>{{$demande->user->fullname}}</td>
    			                    @endif 
                        			<td>
                        			@if (count($demande->messages)) 
                        				<a class="dropdown-toggle" data-toggle="dropdown" href="#">{{count($demande->messages)}} messages dont {{count($demande->messages->where('lu','=',null))}} non lus
                        				<span class="caret"></span></a>
                                		<div class="dropdown-menu messages">
                                    	@foreach($demande->messages->where('lu','=',null) as $message)
                							<a class="dropdown-item" href="{{route('demandes.show',$demande->id)}}#{{$message->id}}">le {{$message->created_at_date}} à {{$message->created_at_time}} par {{$message->user->fullname}}</a>
                                    	@endforeach
                            	    	</div>
                                	
                                	@endif
                                			</td> 
            			                </tr>
            			            @endforeach
    				        </tbody>
    				    </table>
                    	{{--$demandes->links()--}}
                    	<a href="{{route('demandes.index')}}?user={{$user->id}}">Voir toutes les demandes</a>
                    	<div>
        					<a href="{{route('factures.index')}}?user={{$user->id}}">
        					<i class="fas fa-file-alt"></i>
        					Factures
        					</a>
        				</div>
                				
                    	@endif
				</div>
				<div class="card-footer">
					<a href="javascript:history.back()" class="btn btn-info">Retour</a>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
