@extends('layouts.app')
@section('morecss')
<style>
ul.messages li span,ul.messages ul li {font-size:small}
</style>
@endsection
@section('content')
<div class="container mt-5">
            <div class="row">
               <div class="col-lg-7 col-sm-12 col-12">
                  <div class="mendas-data">
                     <h4 class="text-center mb-5">Devis/interventions</h4>

                     <div class="row mb-5">
					 <form action="{{route('demandes.index')}}" method="get">
                		@if (request()->user) <input type="hidden" name="user" value="{{request()->user}}" />@endif
                     <div class="row mb-5">
                        <div class="col-lg-6 col-sm-6 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                   <span id="basic-addon1"> <i class="fas fa-calendar-week mr-2"></i> DU</span>
                                 </div>
                              </label>
                              <div class="col-9">
								 <input type="text" class=" calendar form-control"   value="{{request()->datedeb}}" id="datedeb" name="datedeb" placeholder="jj/mm/aaaa" aria-label="nom" aria-describedby="basic-addon2">
                                 <hr class="mt-1 mb-1">
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                    <i class="fas fa-calendar-week mr-2"></i> AU
                                 </div>
                              </label>
                              <div class="col-9">
							  <input type="text" class="form-control calendar" value="{{request()->datefin}}" id="datefin" name="datefin" placeholder="jj/mm/aaaa" aria-label="nom" aria-describedby="basic-addon2">
                                 </div>
                           </div>
						
                        </div>

                        <div class="col-lg-6 col-sm-6 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Matin&eacute;e
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Apr&egrave;s-midi
                              </div>
                           </div>
                        </div>
				    	<div class="col-9 filter_div">
<button class="btn-color filter" type="submit"><i class="fas fa-search"></i> Filtrer</button>
<button onclick="document.getElementById('datedeb').value=document.getElementById('datefin').value='';" class="float-right btn-color cancel" type="submit"><i class="fas fa-window-close"></i> Annuler</button>
                        </div>
                     </div>
</form>

                        
                     </div>

					 @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                @if ($errors->any())
    				<ul class="alert alert-warning">
    					@foreach ($errors->all() as $error)
    					<li>{{$error}}</li> @endforeach
    				</ul>
				@endif 
				@if(session()->has('message'))
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    {!! session('message') !!}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			@endif

                     <div class="table-responsive">
                       <table  class="table" style="width:100%">
                        <thead>
                           <tr>
                               <th><strong>DATES</strong></th>
                               <th><strong>TITRE</strong></th>
                               <th><strong>STATUT</strong></th>
							   @if(!Auth::user()->isClient())
                               <th><strong>CLIENT</strong></th>
				                @endif
                                @if(Auth::user()->isAdmin())<th><strong>VOIR DEVIS </strong></th>@endif
                           </tr>
                        </thead>
                        <tbody>
						@foreach($interventions as $intervention)
                           <tr  @if ($intervention->demande->current_status_id=='PAYEE' && (\Carbon\Carbon::now()->diffInDays($intervention->demande->created_at_date_object)<7)) class="table-warning"
			                @elseif ($intervention->demande->current_status_id=='PAYEE') class="table-danger" 
			                	@endif>
                               <td>
							   {{$intervention->demande->created_at_date}} <br>à {{$intervention->demande->created_at_time}}	   
							   </td>
                               <td><a href="{{route('interventions.show',$intervention->id)}}">{{$intervention->descriptif}}</a></td>
                               <td>@if ($intervention->demande->current_status) {{$intervention->demande->current_status->libelle}} @endif</td>
							   @if(!Auth::user()->isClient())
			                    <td>@if ($intervention->demande->user) {{$intervention->demande->user->fullname}}@endif</td>
			                    @endif 
								@if(Auth::user()->isAdmin())
                               <td ><a href="{{route('voirdevis',$intervention->demande->id)}}"><i class="fas fa-eye"></i></a></td>
                           @endif
							</tr>
						   @endforeach
                          
                        </tbody>
                     </table>
					 {{$interventions->links()}}     
                     </div> 

                     <p><a href="{{route('home')}}" class="text-dark"><i class="fas fa-chevron-left mr-2"></i>Retour</a></p>
                     
                  </div>
               </div>
            </div>
         </div>

         <img src="{{asset('image/PersonnageMécanicien.png')}}" class="comman-image-all1">

@endsection