@extends('layouts.app')
@section('morecss')
<style>
.messages{font-size:small}
</style>
@endsection
@section('content')
<div class="container mt-5">
            <div class="row">
               <div class="col-lg-10 col-sm-12 col-12">
                  <div class="mendas-data">
                     <h4 class="text-center mb-5">Factures @if(request()->user) <span class="small">de {{\App\User::find(request()->user)->fullname}}</span> @endif </h4>
					 <form action="{{route('factures.index')}}" method="get">
					 @if (request()->user) <input type="hidden" name="user" value="{{request()->user}}" />@endif
                     <div class="row mb-5">
                        <div class="col-lg-4 col-sm-4 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                    <i class="fas fa-calendar-week mr-1"></i> DU
                                 </div>
                              </label>
                              <div class="col-9">
							  <input type="text" class="calendar form-control" value="{{request()->datedeb}}" id="datedeb" name="datedeb" placeholder="date debut" aria-label="nom" aria-describedby="basic-addon2">
                                 <hr class="mt-1 mb-1">
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                    <i class="fas fa-calendar-week mr-1"></i> AU
                                 </div>
                              </label>
                              <div class="col-9">
							  <input type="text" class="calendar form-control" value="{{request()->datefin}}" id="datefin" name="datefin" placeholder="date fin" aria-label="nom" aria-describedby="basic-addon2">
                               </div>
                           </div>
					
                        </div>
                        <div class="col-lg-4 col-sm-4 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Matin&eacute;e
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Apr&egrave;s-midi
                              </div>
                           </div>

                        </div>

						<div class="col-6 filter_div">
<button class="btn-color filter" type="submit"><i class="fas fa-search"></i> Filtrer</button>
<button onclick="document.getElementById('datedeb').value=document.getElementById('datefin').value='';" class="float-right btn-color cancel" type="submit"><i class="fas fa-window-close"></i> Annuler</button>
                        </div>					
</form>
                     </div>
					 @if (session('status')) 
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                @if ($errors->any())
    				<ul class="alert alert-warning">
    					@foreach ($errors->all() as $error)
				<li>{{$error}}</li> @endforeach
    				</ul>
				@endif 
				@if(session()->has('message'))
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    {!! session('message') !!}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			@endif

                     <div class="table-responsive">
                       <table class="table" style="width:100%">
                        <thead>
                           <tr>
                               <th><strong>DATES</strong></th>
							   @if(!Auth::user()->isClient())
                               <th><strong>CLIENT</strong></th>
							   @endif
                               <th><strong>TITRE</strong></th>
                               <th><strong>STATUT</strong></th>
                               <th><strong>Local TTC</strong></th>
                               <th><strong>MONTANT VERSE</strong></th>
                               <th><i class="fas fa-file"></i></th>
                           </tr>
                        </thead>
                        <tbody>
						@foreach($demandes as $demande)
                           <tr   @if ($demande->current_status_id=='PAYEE' && (\Carbon\Carbon::now()->diffInDays($demande->created_at_date_object)<7)) class="table-warning"
			                @elseif ($demande->current_status_id=='PAYEE') class="table-danger" 
			                	@endif>
								<td>{{\Carbon\Carbon::createFromFormat('Y-m-d H:i:s',  $demande->date_facture,'UTC')->timezone('America/Martinique')->formatLocalized('%d/%m/%Y')
       }}</td>
			                    @if(!Auth::user()->isClient())
			                    <td>{{$demande->user->fullname}}</td>
			                    @endif 

                               <td>	<strong><a href="{{route('demandes.show',$demande->id)}}">{{$demande->libelle}}</a></strong></td>
							   <td>@if ($demande->current_status) {{$demande->current_status->libelle}} @endif</td>
                               <td>{{number_format($demande->total_ttc,2,',',' ')}}</td>
                               <td>{{number_format($demande->montant_verse,2,',',' ')}}</td>
                               <td>
							   @if (Auth::user()->isAdmin() && $demande->facture)
                        			<a href="{{route('demande.voirfacture',$demande->id)}}">
										<i class="fas fa-download"></i></a>
										@endif
									</td>
                           </tr>
						   @endforeach
                         
                        </tbody>
                     </table>
					 {{$demandes->links()}}
					 @if (Auth::user()->isClient())
                    <h2><a href="{{route('demandes.create')}}" class="btn btn-warning btn-lg"><i class="fas fa-comment"></i> Faire une demande d'intervention</a></h2>
                    @endif
                     </div>

                     <p><a href="{{route('demandes.create')}}" class="text-dark"><i class="fas fa-chevron-left mr-2"></i>Retour</a></p>
                  </div>
               </div>
            </div>
            <img src="image/PersonnageMécanicien.png" class="comman-image-all0">
         </div>
	
@endsection