@extends('layouts.app')
@section('morecss')
<style>
.messages{font-size:small}
.fnt_w{
	font-weight: 400 !important;
}
.fnt_m{color: #f6a940 !important;}
</style>
@endsection
@push('head')
<!-- Styles -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap4.min.css">
   
<!-- Scripts -->
    
<script type="text/javascript" src="js/jquery-3.4.1.min.js"></script>
<script type="text/javascript" src="js/popper.min.js"></script>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/mdb.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript">
   $(document).ready(function() {
   
$('#example').DataTable();
	   jQuery('#datepicker').datepicker({
	  format: 'dd-mm-yyyy',
	  startDate: '+1d'
  });
   } );
</script>
@endpush
@section('content')
<div class="container mt-5">
            <div class="row">
               <div class="col-lg-7 col-sm-12 col-12">
                  <div class="mendas-data">
                     <h4 class="text-center mb-5">Demandes @if(request()->user)<br><small>de {{\App\User::find(request()->user)->fullname}}</small> @endif</h4>
					 <form action="{{route('demandes.index')}}" method="get">
                		@if (request()->user) <input type="hidden" name="user" value="{{request()->user}}" />@endif
                     <div class="row mb-5">
                        <div class="col-lg-6 col-sm-6 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                   <span id="basic-addon1"> <i class="fas fa-calendar-week mr-2"></i> DU</span>
                                 </div>
                              </label>
                              <div class="col-9">
								 <input type="text" class=" calendar form-control"   value="{{request()->datedeb}}" id="datedeb" name="datedeb" placeholder="jj/mm/aaaa" aria-label="nom" aria-describedby="basic-addon2">
                                 <hr class="mt-1 mb-1">
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-3">
                                 <div class="label-text">
                                    <i class="fas fa-calendar-week mr-2"></i> AU
                                 </div>
                              </label>
                              <div class="col-9">
							  <input type="text" class="form-control calendar" value="{{request()->datefin}}" id="datefin" name="datefin" placeholder="jj/mm/aaaa" aria-label="nom" aria-describedby="basic-addon2">
                                 </div>
                           </div>
						
                        </div>

                        <div class="col-lg-6 col-sm-6 col-12">
                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Matin&eacute;e
                              </div>
                           </div>

                           <div class="form-group row mb-0">
                              <label class="col-2">
                                 <div class="label-text">
                                    <i class="fas fa-clock"></i>
                                 </div>
                              </label>
                              <div class="col-10">
                                 <input type="checkbox"> Apr&egrave;s-midi
                              </div>
                           </div>
                        </div>
				    	<div class="col-9 filter_div">
<button class="btn-color filter" type="submit"><i class="fas fa-search"></i> Filtrer</button>
<button onclick="document.getElementById('datedeb').value=document.getElementById('datefin').value='';" class="float-right btn-color cancel" type="submit"><i class="fas fa-window-close"></i> Annuler</button>
                        </div>
                     </div>
</form>
@if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                @if ($errors->any())
    				<ul class="alert alert-warning">
    					@foreach ($errors->all() as $error)
				<li>{{$error}}</li> @endforeach
    				</ul>
				@endif 
				@if(session()->has('message'))
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    {!! session('message') !!}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			@endif
                     <div class="table-responsive">
                       <table  class="table" style="width:100%">
                        <thead>
                           <tr>
                               <th><strong>DATES</strong></th>
                               <th><strong>TITRE</strong></th>
                               <th><strong>STATUT</strong></th>
							   @if(!Auth::user()->isClient())
				                <th><strong>CLIENT</strong></th>
				                @endif
                               <th><strong>MESSAGE</strong></th>
                           </tr>
                        </thead>
                        <tbody>
						@foreach($demandes as $demande)
                           <tr @if ($demande->current_status_id=='PAYEE' && (\Carbon\Carbon::now()->diffInDays($demande->created_at_date_object)<7)) class="table-warning"
			                @elseif ($demande->current_status_id=='PAYEE') class="table-danger" 
			                	@endif>
			                	<td>{{$demande->created_at_date}} à {{$demande->created_at_time}}</td>
								<td>
									<a href="{{route('demandes.show',$demande->id)}}" class="fnt_w">{{$demande->libelle}}</a>
								</td>
								<td>@if ($demande->current_status) {{$demande->current_status->libelle}} @endif</td>
			                    @if(!Auth::user()->isClient())
			                    <td>{{$demande->user->fullname}}</td>
			                    @endif
                               
                               <td class="text-orange">
							   @if (count($demande->messages)) 
							   <a class="dropdown-toggle fnt_w fnt_m" data-toggle="dropdown" href="#" >{{count($demande->messages)}} messages dont {{count($demande->messages->where('lu','=',null))}} non lus
                    				<span class="caret"></span></a>
                            		<div class="dropdown-menu messages">
                                	@foreach($demande->messages->where('lu','=',null) as $message)
            							<a class="dropdown-item" href="{{route('demandes.show',$demande->id)}}#{{$message->id}}">le {{$message->created_at_date}} à {{$message->created_at_time}} par {{$message->user->fullname}}</a>
                                	@endforeach
                        	    	</div>
                            	
                            	@endif

							   </td>
                           </tr>
						   @endforeach
                          
                        </tbody>
                     </table>
					 {{$demandes->links()}}
                     </div> 
					 @if (Auth::user()->isClient())
                    <h2><a href="{{route('demandes.create')}}" class="btn btn-warning btn-lg"><i class="fas fa-comment"></i> Faire une demande d'intervention</a></h2>
                    @endif
                  </div>
				  <p class="pt-4"><a href="javascript:history.back()" class="text-dark"><i class="fas fa-chevron-left mr-2"></i>Retour</a></p>
               </div>
            </div>
         </div>
		

         <img src="image/PersonnageMécanicien.png" class="comman-image-all1">
      </div>
   
@endsection