@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{$adresse->libelle}}</div>
 				@if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                @if ($errors->any())
    				<ul class="alert alert-warning">
    					@foreach ($errors->all() as $error)
    					<li>{{$error}}</li> @endforeach
    				</ul>
    				@endif 
    				@if(session()->has('message'))
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    {!! session('message') !!}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			@endif
				
                <div class="card-body">
					<form method="POST" class=""
						action="{{ route('adresses.update',$adresse->id) }}">
						@csrf
						{{ method_field('patch') }}
						<!-- <div class="col-12">
							<div class="input-group input-group-lg mb-3">
								<div class="input-group-prepend">
									<label for="date_depart" class="input-group-text"><i
										class="fas fa-arrow-right"></i></label>
								</div>
								<input type="date" min="2019-08-28"
									value="2019-08-28" id="date_test" name="date_test"
									placeholder="Date de départ*" class="form-control"/>
								<input type="time" class="form-control"/>
							</div>
						</div> -->
						<div class="form-group">
							<label class="" for="libelle">Libellé</label> <input id="libelle" name="libelle"
								class="form-control form-control-lg" type="text"
								placeholder="ex: chez vous ou chez vos parents" value="{{$adresse->libelle}}" />
						</div>
						<fieldset>
							<legend>
								<i class="fas fa-tag"></i> Adresse
							</legend>
							<div class="form-group">
    							<label class="" for="adresse">Adresse</label> <input id="adresse" name="adresse"
    								class="form-control form-control-lg" type="text"
    								placeholder="ex:1, route de l'union" value="{{$adresse->adresse}}" />
    						</div>
    						
							<div class="form-group">
								<label class="col-form-label col-form-label-lg"
									for="adresse_id">Commune</label>
								<select id="commune_id" name="commune_id"
									class="form-control"> @foreach ($communes as $commune)
									<option value="{{$commune->id}}"
										@if ($commune->id==$adresse->commune_id) selected
										@endif>{{$commune->nom}}</option> @endforeach
								</select>
							</div>
						</fieldset>
						<div class="col-12">
							<div class="form-group row">
								<div class="col">
									<a data-toggle="confirmation" data-title="Confirmer?"
										href="javascript:history.back();"
										class="btn btn-info pull-right form-group">{{__('Cancel')}}</a>
								</div>
								<div class="col">
									<button type="submit" class="btn btn-primary">{{ __('Create')}}</button>
								</div>
							</div>
						</div>
					</form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
