<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTvaTravauxToSocietes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('societes', function (Blueprint $table) {
            $table->uuid('tva_travaux_id')
            ->nullable(true);
            $table->foreign('tva_travaux_id')
            ->references('id')
            ->on('tvas');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('societes', function (Blueprint $table) {
            $table->dropForeign('societes_tva_travaux_id_foreign');
            $table->dropColumn('tva_travaux_id');
        });
    }
}
