<?php namespace App\Repositories;

use App\Intervention;
use Illuminate\Support\Facades\Auth;
class InterventionRepository extends BaseRepository
{
	public function __construct(Intervention $intervention)
	{
		$this->model = $intervention;
	}
/*
	public function getById($id)
	{
		return $this->model->with('adresse','user','messages')->findOrFail($id);
	}
	*/
	public function getPaginate($n,$request=null)
	{
	    
        if (auth()->user()->prestataire=='1')
            $this->model = auth()->user()->interventions()->with('demande')//,'demande.statuts')
            ->orderby('scheduled_at','asc')
            ->orderby('created_at','desc');
        
        else	            
            $this->model = Intervention::with('demande')//,'demande.statuts')
            ->orderby('scheduled_at','asc')
            ->orderby('created_at','desc');
        
        if($request->datedeb)
            $this->model = $this->model->where('created_at','>=',$request->datedeb);
        if($request->datefin)
            $this->model = $this->model->where('created_at','<=',$request->datefin.' 23:59');
        return $this->model->paginate($n);
	}
}