<?php namespace App\Repositories;


use Illuminate\Database\Eloquent\Model;

abstract class BaseRepository
{
    protected $model;//la référence à l'objet Repository
	protected $model_id = null;//stocke l'id de l'enregistrement créé
	/**
	 * référence l'instance de modele 
	 * enregistrement de base en cours
	 */
	protected $modelInstance;
	
	public function getModelId(){
		return $this->model_id;
	}
	
	public function save(Model $model, Array $inputs, $create)
	{
		$model->save();
	}
	
	public function getPaginate($n,$request = null)
	{
		return $this->model->paginate($n);
	}
	
	public function getAll(){
		return $this->model->get();
	}
	
	public function store(Array $inputs)
	{
		$model = new $this->model($inputs);		
		
		//$model->id = (string) Str::uuid();
		
		
		$this->save($model, $inputs, true);
		
		return $model;
	}

	public function getById($id)
	{
		return $this->model->findOrFail($id);
		
	}

	public function update($id, Array $inputs)
	{
		$model = $this->getById($id);
		$model->update($inputs);
		$this->save($model, $inputs, false);
		return $model;
	}

	public function destroy($id)
	{
		$this->getById($id)->delete();
	}
	public function desc()
	{
		$this->model = $this->model->orderBy($this->model->getTable().'.created_at','desc');
		return $this;
	}
}
