<?php

namespace App\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Auth;
use App\Events\MessageCreated as MessageCreatedEvent;
use Illuminate\Support\Facades\Mail;
use App\Mail\MessagePosted;
use App\User;

class MessageCreated
{
    protected $listen = [
        \App\Events\MessageCreated::class => [
            \App\Listeners\MessageCreated::class,
        ],
    ];

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(MessageCreatedEvent $event)
    {
        //Un message a été posté
        //Envoyer une notiofi mail au destinataire
        //Si l'expediteur n'est pas le client auteur de la demande (ie: c'est un assistant qui repond)
        //et si il ne s'agit pas du message de rapport
        if ($event->message->demande->user_id != Auth::id()
            && $event->message->demande->message_rapport_id != $event->message->id)
            Mail::to($event->message->demande->user->email)
            ->send(new MessagePosted($event->message));
        //sinon il s'agit d'un message du client
        //il faut répondre à tous les assistant qui ont participé à la discussion
            else{
                $messages = $event->message->demande->messages()->get();
                $assistants = $messages->reject(function($message) {
                    return $message->user_id == Auth::id(); 
                })
                ->map(function($message){
                    return $message->user->email;
                });
                if($assistants->count())
                    foreach ($assistants->unique() as $assistant_email)
                        Mail::to($assistant_email)
                        ->send(new MessagePosted($event->message));
                //personne n'a encore répondu
                //envoyer un email aux admins
                else {
                    $admins = User::whereAdmin('1')->get();
                    if($admins->count())
                        foreach ($admins as $admin)
                            Mail::to($admin->email)
                            ->send(new MessagePosted($event->message));
                }
                
            }
    }
}
