<?php

namespace App\Http\Controllers;

use Faker\Provider\Uuid;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use App\Document;
use App\Intervention;
use App\Demande;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use App\ModePaiement;
use App\Message;
use App\Societe;


class ChoixPaiementController extends Controller
{
    public function __construct(){
        $this->middleware('auth');
        $this->middleware('verified');
        //dd(Societe::first());
        $societe = Societe::first();
        if ($societe->email_uniskip && $societe->motdepasse_uniskip)
            config([
                    'payments.uniskip.merchant'=>$societe->email_uniskip,
                    'payments.uniskip.password'=>$societe->motdepasse_uniskip]);
        
            
        //TODO: Si pb de paiement précédent on empeche toute nouvelle transaction
        //ex: transaction ok mais non enregistrée sur le site
    }
    
    public function annulePaiements($dem_id){
        $sql = "
        DELETE FROM `demande_statut` 
        WHERE `demande_statut`.`demande_id` = '" . $dem_id."' 
            AND (`demande_statut`.`statut_id` = 'SOLDEE' 
            OR `demande_statut`.`statut_id` = 'LIVREE' 
            OR `demande_statut`.`statut_id` = 'PAYEE'
            OR `demande_statut`.`statut_id` = 'EN_PAIEMENT');
        UPDATE `demandes` SET `facture` = NULL, `num_facture` = NULL,`date_facture` = NULL, `montant_verse` = '0' 
        WHERE `demandes`.`id` = '" . $dem_id."';
        DELETE FROM `paiements` 
        WHERE `demande_id` = '" . $dem_id."'
        ";
        DB::unprepared($sql);
        return redirect(route('demandes.show',$dem_id));
    }
    /*
    public function payer(Request $request){
        //DB::enableQueryLog();
        $demande = Demande::findOrFail($request->demande_id);
        Session::put('demande_id',$demande->id);
        
        if ($request->bpadevis!='on' || $request->cgv!='on' )
            return redirect(route('demandes.show',$demande->id))->withErrors(["cocher"=>"Vous devez accepter le Bon pour accord et les CGV pour pouvoir continuer"]);
            
            if ($demande->statuts->last()->id == 'DEVISEE'){
                //dd(DB::getQueryLog(),$id,$request->all());
                
                $demande->statuts()->attach(['statut_id'=>'EN_PAIEMENT']);
                
                $message = $demande->messages()->create(['user_id'=>Auth::id(),'text' => "J'accepte sans réserve le devis qui m'est proposé"]);
                //Ajout de la signature manuscrite si elle exsite
                if ($request->output){
                    $message->documents()->attach($this->addSignatureToMessage($request->output,'signature_devis'));
                }
                
                
                return
                //redirect(route('demandes.show',$demande->id));//
                redirect(route('choixpaiement',$demande->id));
            }
            else if ($demande->statuts->last()->id == 'EN_PAIEMENT'){
                //Exécuter le paiement
                //transwaction vers CB
                return  //redirect(route('demandes.show',$demande->id));
                redirect(route('choixpaiement'));
            }
            else if ($demande->statuts->last()->id == 'LIVREE')
                //dd(DB::getQueryLog(),$id,$request->all());
                return  //redirect(route('demandes.show',$demande->id));
                redirect(route('choixpaiement'));
                else
                    return redirect(route('demandes.show',$demande->id))->withErrors(["statut_demande"=>"statut non valide"]);
    }*/
    
    
    private function addSignatureToMessage($output,$libelle='signature'){
        $document = Document::create([
            "libelle" => $libelle,//'message_' . $message->id,
            "nom_fichier" => 'tmp_signature.png',//$fichier->getClientOriginalName(),
            "url" => '',
            "type_mime" => 'png'
        ]);
        $new_name = $document->id.'.png';
        $document->update(['nom_fichier' => $new_name]);
        
        require_once public_path().'/signature-to-image-master/signature-to-image.php';
        
        $json = $output; // From Signature Pad
        $img = sigJsonToImage($json,['imageSize' => [298, 155]]);
        
        $path = imagepng($img, storage_path().'/app/documents/'.$new_name);
        
        
        //$path = basename($img->store('documents'));
        imagedestroy($img);
        return $document;
        
    }
                
    public function choixMoyenPaiement(Request $request){
        //DB::enableQueryLog();
        $demande = Demande::findOrFail($request->demande_id);
        
         
        if ($request->bpadevis!='on' || $request->cgv!='on' )
            return redirect(route('demandes.show',$demande->id))->withErrors(["cocher"=>"Vous devez accepter le Bon pour accord et les CGV pour pouvoir continuer"]);
        
        //$demande->statuts()->attach(['statut_id'=>'EN_PAIEMENT']);
            
        if ($demande->statuts->last()->id == 'DEVISEE'){
            //dd(DB::getQueryLog(),$id,$request->all());
            
            $demande->statuts()->attach(['statut_id'=>'EN_PAIEMENT']);
            
            $message = $demande->messages()->create(['user_id'=>Auth::id(),'text' => "J'accepte sans réserve le devis qui m'est proposé"]);
            //Ajout de la signature manuscrite si elle existe
            if ($request->output){
                $message->documents()->attach($this->addSignatureToMessage($request->output,'signature_devis'));
            }

        }
        else if (!($demande->current_status_id == 'EN_PAIEMENT' || $demande->current_status_id == 'LIVREE'))
            return redirect(route('demandes.show',$demande->id))->withErrors(["statut_demande"=>"statut non valide"]);
        /*else {
            $demande->statuts()->attach(['statut_id'=>'EN_PAIEMENT_SOLDE']);
        }*/
        
        
        //On a une demande en sesion
        //dd(Session::all());
        /*
        if (!($demande_id = Session::get('demande_id')))
            return redirect(route('home'))->withErrors(["message"=>"Erreur de parcours"]);
            
        $demande= Demande::findOrFail($demande_id);*/
        //$montant = $demande->montant_a_payer;//round($demande->total_ttc - $demande->montant_verse, 2);
        
        
        //on met la demande en session
        //Plus necessaire ici. Déplacé dans la page du moyen de paiement
        //Session::put('demande_id',$demande->id);
        
        
        $mode_paiements = ModePaiement::where('active',true)->oldest()->get();
        //dd($demande);
        return view('payment.choixMoyenPaiement',compact('demande','mode_paiements'));
    }
    
    public function getQRCode(){
        $demande= Demande::findOrFail(session('demande_id'));
        // Make Post Fields Array
        $data1 = [
            'amount' => $demande->montant_a_payer,//$demande->total_ttc - $demande->montant_verse,
            'currency' => 'EUR',
            'creditemail' => config('payments.uniskip.merchant'),
            'password' => config('payments.uniskip.password'),
            'label' => $demande->transaction_id,
            'operation_code' => '234',
            'cashing_id' => '45',
            'fcm_token' => 'eyJuZmNfcXJfY2FzaGluZ19wYX'
        ];
        
        $strData1='';
        foreach($data1 as $key=>$value) {
            $strData1 .= $key . "=" . $value . "&";
        }
        
        $curl = curl_init();
        
        $ok = curl_setopt_array($curl, array(
            CURLOPT_URL => "https://".config('payments.uniskip.api_url').config('payments.uniskip.QR.generer_endpoint'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POST=>1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data1,
            
        ));
        
        $content = curl_exec($curl);
        $err = curl_error($curl);
        
        $info = curl_getinfo($curl);
        //header('Content-Type:' . $info['content_type']);
        
        
        curl_close($curl);
        
        if ($err) {
            $reponse = implode($data1,'|')."cURL Error #:" . $err;
            return response()->json($reponse);
        } else {
            $reponse = implode('/',$data1).$content;
        }
        
        return Response::make($content, 200, [
            'Content-Type' => 'image/png',
            'Content-Disposition' => 'inline; filename="theqrcode"'
        ]);
    }
    
    /**
     * Etape 1 : affiche la vue du moyen de paiement uniskipQR
     * @param Request $request
     * @return unknown|\Illuminate\View\View|\Illuminate\Contracts\View\Factory
     */
    public function uniskipQRPayment(Request $request){
        
        if (empty(config('payments.uniskip.merchant'))
            || empty(config('payments.uniskip.password')))
            return Redirect::to(route('home'))->withErrors(['message'=>'Une erreur est survenue. Merci de contacter l\'administrateur'])
            ->send();
        
        $demande= Demande::findOrFail($request->demande_id);
        $montant = $demande->montant_a_payer;
        
        $transaction_id = 'UQR_'.Str::uuid();
        
        $demande->update(['transaction_id'=>$transaction_id]);
             
        $link_to='home';

        //On met la demande en session pour gérer la protection contre les doublons notamment
        Session::put('demande_id',$demande->id);
        
        return view('payment.paiementUniskipQR',compact('montant','transaction_id','link_to'));
    }
    
    /**
     * Etape 1 : affiche la vue du moyen de paiement uniskipCB
     * @param Request $request
     * @return unknown|\Illuminate\View\View|\Illuminate\Contracts\View\Factory
     */
    public function uniskipCBPayment(Request $request){
        //dd(empty(config('payments.uniskip.merchant')));
        if (empty(config('payments.uniskip.merchant'))
            || empty(config('payments.uniskip.password')))
            return Redirect::to(route('home'))->withErrors(['message'=>'Une erreur est survenue. Merci de contacter l\'administrateur'])
            ->send();
            
        $demande= Demande::findOrFail($request->demande_id);
        $montant = $demande->montant_a_payer;
        
        //$transaction_id = 'HDCB'.Str::uuid();
        
        //$demande->update(['transaction_id'=>$transaction_id]);
        
        //On met la demande en session pour gérer la protection contre les doublons notamment
        Session::put('demande_id',$demande->id);
        
        $cblink = $this->getUniskipCBUrl($demande);
        
        $transaction_id = 'UCB_'.$cblink['demande_id'];//demande_id est le numero de transaction chez uniskip
        
        $demande->update(['transaction_id'=>$transaction_id]);
        
        
        
        //dd($cblink);
        if ($cblink['status'] == 'erreur1')
            return redirect(route('home'))->withErrors(['message'=>$cblink['status']]);
        return view('payment.paiementUniskipCB',compact('montant','transaction_id','cblink'));
    }
    
    /**
     * Recupere l'url vers le paiement CB uniskip
     * Execution d'un script curl qui renvoie l'url ainsi que l'id de la transaction initiée par uniskip ("demande")
     * Contrairment au mode QR cet id est créé par uniskip
     * @param unknown $demande
     * @return array
     */
    private function getUniskipCBUrl($demande){
        //dd(config('payments.uniskip.uniskip_merchant'));
        // Make Post Fields Array
           
        $data1 = [
            'email' => config('payments.uniskip.merchant'),
            'pass' => config('payments.uniskip.password'),
            'etape' => '1',
            'id_compte_a_debiter' => '',
            'email_du_debite' => Auth::user()->email,
            'taxe_debiter_or_crediter' => '0',
            'periodicitee' => 'tj',
            'nb_tranferts' => '1',
            'date_transfert' => 'NOW',
            'email_a_crediter' => config('payments.uniskip.merchant'),
            'montant' => $demande->montant_a_payer,
            'libelle_devise_montant' => 'EUR',
            'libelle' => 'old_'.$demande->transaction_id,
            'code_operation' => config('payments.uniskip.CB.code_operation')
        ];
        $curl = curl_init();
        
        $ok = curl_setopt_array($curl, array(
            CURLOPT_URL => "https://".config('payments.uniskip.api_url')."demande_approvisionnement.php",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POST=>1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data1,
            CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Accept: application/json'
            )
        ));
        
        $content = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        
        if ($err)
            $reponse = array_merge($data1,['err' => $err]);
        else
            $reponse = json_decode($content,true);
    
        return $reponse;
    }
    
    /**
     * Vérification qu'aucune transaction avec cet id
     *  n'existe déjà parmi les factures payées
     *  Si OK (aucune transaction)
     *  Alors vérifier chez uniskip si la transaction a été enregistrée
     */
    private function transactionEnregistree($transaction_id){
        if (DB::table('paiements')->where('transaction_id',$transaction_id)->exists()){
            //Probleme on essaie de faire passer l'id d'une ancienne transaction
            return true;
        }
        return false;
        
        
    }
    
    
    /**
     * Interroge le serveur uniskip pour savoir si la transaction est ok
     * méthode appelée à intervalle regulier par JS
     * dans la page uniskip payment
     */
    public function uniskipQRVerif(Request $request){
        $demande= Demande::findOrFail(($request->demande_id)?$request->demande_id:session('demande_id'));
        //dd(config('payments.uniskip.QR.merchant'));
        // Make Post Fields Array
        $data1 = [
            'creditemail' => config('payments.uniskip.merchant'),
            'password' => config('payments.uniskip.password'),
            'label' => $demande->transaction_id,
        ];
        $curl = curl_init();
        
        $ok = curl_setopt_array($curl, array(
            CURLOPT_URL => "https://".config('payments.uniskip.api_url').config('payments.uniskip.QR.verifier_endpoint'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POST=>1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data1,
            CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Accept: application/json'
            )
        ));
        
        $content = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        
        if ($err)
            $reponse = array_merge($data1,['err' => $err]);
        else
            $reponse = json_decode($content,true);
        
        if (empty($err) && (($reponse['status']=='ok') && ($reponse['devise']=='EUR')
            && ($reponse['amount'] == round($demande->montant_a_payer,2))
            )
            )
        {
            $request->merge(['montant'=>$demande->montant_a_payer,'transaction_id'=>$demande->transaction_id]);
            
            $retour = $this->paymentSuccess($request,'uniskipQR',$request->transaction_id);
            return response()->json(['payment'=>'ok','location'=>$retour->getTargetUrl()]);
        }
        else
        {
            return response()->json(['payment'=>'ko','reponse'=>$reponse]);
        }
    }
    
    /**
     * Interroge le serveur uniskip pour savoir si la transaction est ok
     * méthode appelée à intervalle regulier par JS
     * dans la page uniskip payment
     */
    public function uniskipCBVerif(Request $request,$usCBdemande_id){
        $demande= Demande::findOrFail(($request->demande_id)?$request->demande_id:session('demande_id'));

        $data1 = [
            'id' => $usCBdemande_id,
            'etape' => '6',
        ];
        $curl = curl_init();
        
        $ok = curl_setopt_array($curl, array(
            CURLOPT_URL => "https://".config('payments.uniskip.api_url').config('payments.uniskip.CB.verifier_endpoint'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POST=>1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data1,
            CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Accept: application/json'
            )
        ));
        
        $content = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        
        if ($err)
            $reponse = array_merge($data1,['err' => $err]);
            else
                $reponse = json_decode($content,true);

        if (!$err && (($reponse['statut']=='4') //Accepté par débiteur
            && ($reponse['resultat_transaction']=='1') //Débit effectué
                && ($reponse['devise']=='EUR')
                && ($reponse['montant'] == round($demande->montant_a_payer,2))
                && ($reponse['email_a_crediter']==config('payments.uniskip.merchant'))
                )
            )
        {
            $request->merge(['montant'=>$demande->montant_a_payer,'transaction_id'=>$demande->transaction_id]);
            
            $retour = $this->paymentSuccess($request,'uniskipCB',$request->transaction_id);
            return response()->json(['payment'=>'ok','location'=>$retour->getTargetUrl()]);
        }
            else return response()->json(['payment'=>'ko','reponse'=>$reponse]);
    }
    
    public function paymentTest(Request $request){
        $demande = Demande::findOrFail($request->demande_id);
        $montant = $request->montant;
        
        $transaction_id = ''.Str::uuid();
        
        $demande->update(['transaction_id'=>$transaction_id]);
        
        //$this->enregistreCommande($id_offre, $qte, $taux_tva,$transaction_id);
        $request->session()->put('demande_id',$demande->id);
        
        //Pas de vue ni de saisie, on execute directement le paiement
        return $this->paymentSuccess($request,'test',$transaction_id);
    }
    
    public function paymentCheque(Request $request){
        $demande = Demande::findOrFail($request->demande_id);
        $montant = $request->montant;
        
        $transaction_id = 'HDCK'.Str::uuid();
        
        $demande->update(['transaction_id'=>$transaction_id]);
        
        //$this->enregistreCommande($id_offre, $qte, $taux_tva,$transaction_id);
        $request->session()->put('demande_id',$demande->id);
        
        //Pas de vue ni de saisie, on execute directement le paiement
        return $this->paymentSuccess($request,'cheque',$transaction_id);
    }
    
    public function cbPayment(Request $request){
        $id_offre = $request->id_offre;
        $qte = $request->qte;
        $taux_tva = Auth::User()->Adresse->Pays->taux_tva;
        
        $demande = Demande::findOrFail($id_offre);
        $montant = round($qte * $offre->pu * (1+$taux_tva/100), 2);
        
        $transaction_id = 'HD__'.Uuid::generate(4);
        
        
        $this->enregistreCommande($id_offre, $qte, $taux_tva,$transaction_id);
        $request->session()->put('offre',$id_offre);
        $request->session()->put('qte', $qte);
        
        return view('payment.paiementCB',compact('montant','transaction_id','id_offre','qte','taux_tva','link_to'));
    }
    
    /*
    public function paiementCBsuccess(Request $request){
        // Set your secret key: remember to change this to your live secret key in production
        // See your keys here: https://dashboard.stripe.com/account/apikeys
        \Stripe\Stripe::setApiKey('sk_test_JbeWsEf0Oie0WfCLcvhKlLTU0015WIDaFA');
        
        // Token is created using Checkout or Elements!
        // Get the payment token ID submitted by the form:
        $token = $_POST['stripeToken'];
        $charge = \Stripe\Charge::create([
            'amount' => 999,
            'currency' => 'usd',
            'description' => 'Example charge',
            'source' => $token,
        ]);
    }*/
    
    
    /**
     * Payment success est appelé par chaque module de paiement. 
     * En parametre on a donc soit une donnée POST (request) 
     * soit une donnée en provenance de json ou autre
     * @param Request $request
     * @param unknown $mode_paiement
     * @param unknown $transaction_id
     * @return \App\Http\Controllers\unknown
     */
    public function paymentSuccess(Request $request,$mode_paiement,$transaction_id){
       
        $retour = $this->executePaiement($mode_paiement, $request->montant, $transaction_id);
        
        return $retour;
    }
    
    private function enregistrePaiement($demande, $montant, $mode_paiement, $transaction_id = ''){
        $paiement = $demande->paiements()->create([
            'montant' =>$montant,
            'mode_paiement_id' => ModePaiement::where('config','=',$mode_paiement)->first()->id,
            'transaction_id' => $transaction_id
        ]);
        
    }
    
    /**
     * enregistrerPaiementManuel est une méthode route
     * appelée quand un paiement a été réalisé 
     * mais que le retour n'a pas pu être effectué 
     * (statut non nmis à jour et pas d'entrée du règlement dans la table paiement)
     * ex: coupure internet, fermeture de page avant le retour du serveur de paiement...
     * @param Request $request
     */
    public function enregistrerPaiementManuel(Request $request){
        $demande = Demande::findOrFail($request->demande_id);
        
        if($this->transactionEnregistree($demande->transaction_id))
            abort(403,'la transaction a déjà été enregistrée');
        
        Session::put('demande_id',$demande->id);
        
        if (
            (substr($demande->transaction_id,0,3) == "UQR" && $paiement = $this->uniskipQRVerif($request))
            || (substr($demande->transaction_id,0,3) == "UCB" && $paiement = $this->uniskipCBVerif($request, substr($demande->transaction_id,4)))
            )
            //une transaction uniskip a été effectuée mais pas enregistrée
            return redirect(route('demandes.show',$demande->id))->with('message','Paiement enregistré');
    }
    
    private function creeFacture($demande){
        $maxNum = Demande::orderBy('date_facture', 'desc')->first()->num_facture;
        
        $now = Carbon::now();
        
        if ($maxNum){
            $tMax = explode('-',$maxNum);
            $derDateYear = $tMax[0];
            $increment = $tMax[1];
            $nouvNum=($now->year == $derDateYear)?$increment+1:1;
        }
        else $nouvNum = 1;
        
        $nomCompletClient = ($demande->user->societe)
        ?Auth::user()->societe
        :Auth::user()->full_name;
        $adresseCompleteClient = $demande->user->adresses->where('par_defaut','=','1')->first()->adresse
        ."\n".$demande->user->adresses->where('par_defaut','=','1')->first()->commune->code_postal
        .' '.$demande->user->adresses->where('par_defaut','=','1')->first()->commune->nom;
        
        $demande->update([
            'num_facture'=>$now->year.'-'.$nouvNum,
            'date_facture'=>$now,
            'facture'=>1,
            'nomcomplet_client' => $nomCompletClient,
            'adressecomplete_client' => $adresseCompleteClient,
        ]);
        
        if ($demande->user->siret)
            $demande->update(['siret_client'=>$demande->user->siret]);
            
    }
    
    
    public function creerFactureAdmin(Request $request){
        $demande = Demande::findOrFail($request->demande_id);
        if (!(Auth::user()->isAdmin() 
            && ($demande->current_status_id=='EN_PAIEMENT' || $demande->current_status_id=="LIVREE") 
            && $demande->dernierPaiement->modePaiement->config=='cheque'))
            return redirect(route('home'))->withErrors('message',"Erreur de statut");
        
        if (round($demande->montant_verse,2)==round($demande->total_ttc,2)){
            $demande->statuts()->attach(['statut_id'=>'SOLDEE']);
        }else
            $demande->statuts()->attach(['statut_id'=>'PAYEE']);
        
        $message = $demande->messages()->create(['user_id'=>Auth::id(),'text' => $request->message_text."\n".$request->infos_cheque,'inemail_flag'=>false]);
            
        if (!$demande->facture)
        {
             $this->creeFacture($demande);
             
             return redirect(route('home'))->with('message',"Facture créée. Un message a été envoyé au client<br>".$message->text);
        }
        else return redirect(route('home'))->with('message',"Facture soldée. Un message a été envoyé au client<br>".$message->text);
    }
    
    /** 
     * Appelé lors de du retour d'un paiement vérifié et réussi
     * @param unknown $id_offre
     * @param unknown $qte
     * @return unknown
     */
    private function executePaiement($mode_paiement, $montant, $transaction_id){
        /*
         *  Gestion de la facturation
         *
         *  On devrait faire une boucle
         *  pour chaque produit
         *  enregistrer une ligne_facture 
         *  calculer total HT et total ttc pour enregistrer dans facture
         *  Mais pour le moment on n'achète qu'un seul seul produit par facture
         */
        $demande = Demande::findOrFail(session('demande_id'));
        
        if (round($demande->montant_verse,2)>=round($demande->total_ttc,2)
            || $demande->current_status=='SOLDEE'
            )
            //On essaie de payer une demande plus que necessaire
            //(multi-clic sur bouton, js désactivé ou autre bug)
            return redirect(route('home'))->withErrors("message","Erreur PM02 : Erreur paiement ");
            
        
        //enregistre une entrée dans la table de paiement
        $this->enregistrePaiement($demande, $montant, $mode_paiement,$transaction_id);
        
        //on augmente le montant verse du montant à payer
        $demande->update(
            ['montant_verse'=>$demande->montant_verse + $demande->montant_a_payer]
            );
        
        $message = $demande->messages()->create(['user_id'=>Auth::id(),'text' => 'Un paiement de '. $montant.' € a été effectué','inemail_flag'=>true]);
        
        //On envoie un email au client avec la confirmation de son paiement
        $emailUser = Auth::user()->email;
        Mail::raw('Votre paiement a bien été effectué sur la plateforme HelloDjo. Merci pour votre confiance', function($message) use ($emailUser)
            
        {
            $message->to($emailUser)->subject('Paiement effectué ');
        });
       
        
        
        // le paiement étant validé
        // On peut  lancer l'édition d'une facture
        // si la demande n'a pas encore de numero de facture alors c'est le premier paiement
        if (!$demande->facture)
        {
            if ($mode_paiement!='cheque'){
            //On ne crée pas de facture en mode de paiement par chèque
            //On ne met pas le statut à payer
                $this->creeFacture($demande);
                $demande->statuts()->attach(['statut_id'=>'PAYEE']);
            }
        }
        if (($mode_paiement!='cheque') && (round($demande->montant_verse,2)==round($demande->total_ttc,2))){
            $demande->statuts()->attach(['statut_id'=>'SOLDEE']);
        }
        
        
        
            
       //On efface tout de la session
        Session::forget('demande_id');
        //echo $demande->montant_verse.'<br>'.$demande->total_ttc;
        //dd(($demande->montant_verse - $demande->total_ttc));
        //dd(redirect(route('home'))->with("message","Votre paiement a été pris en compte"));
        return redirect(route('home'))->with("message","Votre paiement a été pris en compte");
    }
    
}
