<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;
use Carbon\Carbon;

class Demande extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'num_facture',
        'libelle',
        'facture',
        'date_facture',
        'total_ht',
        'total_ttc',
        'pcent_acompte',
        'montant_verse',
        'transaction_id',
        'nomcomplet_client',
        'adressecomplete_client',
        'siret_client',
        'user_id',
        'adresse_id',
        'message_rapport_id'
    ];

    public function user()
    {
        // Relation 1..n
        return $this->belongsTo(User::class);
    }

    public function adresse()
    {
        // Relation 1..n
        return $this->belongsTo(Adresse::class);
    }

    public function intervention()//interventions()
    {
        // Relation 1..n
        //return $this->hasMany(Intervention::class);
        return $this->hasOne(Intervention::class);
    }

    public function messages()
    {
        // Relation 1..n
        return $this->hasMany(Message::class)->orderby('created_at','asc');
    }
    
    public function paiements()
    {
        // Relation 1..n
        return $this->hasMany(Paiement::class)->orderby('created_at','asc');
    }
    
    public function ligne_demandes()
    {
        // Relation 1..n
        return $this->hasMany(Ligne_demande::class);
    }

    public function statuts()
    {
        // Relation n..n
        return $this->belongsToMany(Statut::class)->withTimestamps()->orderby('demande_statut.created_at','asc');//orderby('pivot_created_at','asc');;
    }
    public function getCreatedAtDateAttribute(){
        //return $this->created_at->timezone(config('app.timezone'))->formatLocalized('%d %B %Y');
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at,'UTC')->timezone('America/Martinique')->formatLocalized('%d %B %Y');
        //return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->formatLocalized('%d %B %Y');
    }
    public function getCreatedAtTimeAttribute(){
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at,'UTC')->timezone('America/Martinique')->format('H:i');
        //return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('H:i');
    }
    public function getCreatedAtDateObjectAttribute(){
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at,'UTC')->timezone('America/Martinique');
        //return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at);
    }
    
    public function getCurrentStatusAttribute(){
        if ($this->statuts->last())
            return $this->statuts->last();
        return false;
    }
    
    public function getCurrentStatusIdAttribute(){
        if ($this->statuts->last())
            return $this->statuts->last()->id;
        return false;
    }
    
    public function isPaid(){
        return $this->statuts->find('PAYEE');
    }
    
    public function getMontantAcompteAttribute(){
        $mnt =($this->pcent_acompte && $this->pcent_acompte<100)?
            round($this->pcent_acompte/100*$this->total_ttc,2):
            $this->total_ttc;
        return $mnt;
    }
    
    public function getMontantAPayerAttribute(){
        $mnt = ($this->montant_verse==0)?
        $this->getMontantAcompteAttribute():
        $this->total_ttc-$this->montant_verse;
        //echo ($this->total_ttc-$this->montant_verse) +$this->getMontantAcompteAttribute();
        //echo $this->total_ttc;
        
        return $mnt;
    }
    public function getDernierPaiementAttribute(){
        if ($this->paiements->last())
            return $this->paiements->last();
        return false;
    }
}
