<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Adresse extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'libelle',
        'adresse',
        'par_defaut',
        'user_id',
        'commune_id'
    ];

    public function user()
    {
        // Relation 1..n
        return $this->belongsTo(User::class);
    }

    public function commune()
    {
        // Relation 1..n
        return $this->belongsTo(Commune::class);
    }

    public function demandes()
    {
        // Relation 1..n
        return $this->hasMany(Demande::class);
    }
}
