
<?php $__env->startSection('morecss'); ?>
<style>
ul.messages li span,ul.messages ul li {font-size:small}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><h1 class="float-left">Devis/interventions</h1>
                <form action="<?php echo e(route('interventions.index')); ?>" method="get">
                    	<div class="form-group float-right">
                    		<div class="input-group mb-2">
                              	<div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">du</span>
                                </div>
                                <input type="date" class="form-control" value="<?php echo e(request()->datedeb); ?>" id="datedeb" name="datedeb" placeholder="date debut" aria-label="nom" aria-describedby="basic-addon2">
                        		
                            </div>
                            <div class="input-group mb-2">
                              <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">au</span>
                                </div>
                                <input type="date" class="form-control" value="<?php echo e(request()->datefin); ?>" id="datefin" name="datefin" placeholder="date fin" aria-label="nom" aria-describedby="basic-addon2">
                            </div>
                            <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i> Filtrer</button>
							<button onclick="document.getElementById('datedeb').value=document.getElementById('datefin').value='';" class="float-right btn btn-secondary" type="submit"><i class="fas fa-window-close"></i> Annuler</button>
                    		
                    	</div>
                    </form>
                </div>
 				<?php if(session('status')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
    				<ul class="alert alert-warning">
    					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    					<li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    				</ul>
				<?php endif; ?> 
				<?php if(session()->has('message')): ?>
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    <?php echo session('message'); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			<?php endif; ?>
                <div class="card-body">
                	<table class="table table-sm">
				        <thead>
				            <tr>
				               <th>Date</th>
				                <th>Titre</th>
				                <th>Statut</th>
				                <?php if(!Auth::user()->isClient()): ?>
				                <th>Client</th>
				                <?php endif; ?>
				                <?php if(Auth::user()->isAdmin()): ?><th>Voir devis</th><?php endif; ?>
				        </thead>
				        <tbody>
				        <?php $__currentLoopData = $interventions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intervention): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				            <tr 
			                <?php if($intervention->demande->current_status_id=='PAYEE' && (\Carbon\Carbon::now()->diffInDays($intervention->demande->created_at_date_object)<7)): ?> class="table-warning"
			                <?php elseif($intervention->demande->current_status_id=='PAYEE'): ?> class="table-danger" 
			                	<?php endif; ?>>
			                	<td><?php echo e($intervention->demande->created_at_date); ?> à <?php echo e($intervention->demande->created_at_time); ?></td>
			                    <td class="text-primary">
			                    	<strong><a href="<?php echo e(route('interventions.show',$intervention->id)); ?>"><?php echo e($intervention->descriptif); ?></a></strong>
			                    </td>
			                    <td><?php if($intervention->demande->current_status): ?> <?php echo e($intervention->demande->current_status->libelle); ?> <?php endif; ?></td>
			                    <?php if(!Auth::user()->isClient()): ?>
			                    <td><?php if($intervention->demande->user): ?> <?php echo e($intervention->demande->user->fullname); ?><?php endif; ?></td>
			                    <?php endif; ?> 
                    			<?php if(Auth::user()->isAdmin()): ?>
                    			<td>
                    			<strong><a href="<?php echo e(route('voirdevis',$intervention->demande->id)); ?>"><i class="fas fa-eye"></i></a></strong>
                    			</td> 
                    			<?php endif; ?>
			                </tr>
			            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				        </tbody>
				    </table>
                	<?php echo e($interventions->links()); ?>                	
                </div>
                <div class="card-footer">
					<a href="javascript:history.back()" class="btn btn-info">Retour</a>
				</div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/hellodjo/resources/views/interventions/index.blade.php ENDPATH**/ ?>