<?php $__env->startSection('morecss'); ?>
<style>
.form-control-file{border-bottom:1px solid #ddd;padding-bottom:0.5em;margin-bottom:0.5em}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><h1>Nouveau devis d'intervention</h1></div>
 				<?php if(session('status')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
        				<ul class="alert alert-warning">
        					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        					<li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        				</ul>
        				<?php endif; ?> 
        				<?php if(session()->has('message')): ?>
        				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                        <?php echo session('message'); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                          </button>
                        </div>
    			<?php endif; ?>
					
                <div class="card-body">
                   	<form method="POST" class="" enctype="multipart/form-data"
						action="<?php echo e(route('interventions.store')); ?>">
						<?php echo csrf_field(); ?>
						<p>Affecter une intervention à la demande <em><?php echo e($demande->libelle); ?></em></p>
						<input type="hidden" name="demande_id" value="<?php echo e($demande->id); ?>"/>
						<fieldset>
							<legend>
								<i class="fas fa-tag"></i> Descriptif de l'intervention
							</legend>
							<div class="form-group">
								<label class="" for="descriptif">Descriptif</label> 
								<textarea id="descriptif" name="descriptif"
									class="form-control" rows="10"><?php echo e(old('descriptif')?old('descriptif'): 'intervention sur '.$demande->libelle); ?></textarea>
							</div>
							<div class="form-group">
                            	<label for="document">Uploader le descriptif détaillé</label>
                                <input type="file" class="form-control-file" id="document" name="descriptif_detaillé">
                            </div>
						</fieldset>
						
						<fieldset>
							<legend><i class="fas fa-tools"></i> Affecter un prestataire</legend>
        					<div class="form-group">
        						<?php if(count($prestataires) > 0): ?>
        						<label class="col-form-label col-form-label-lg"
        							for="user_id">Prestataire</label>
        						<select id="user_id" name="user_id"
        							class="form-control"> 
        							<?php $__currentLoopData = $prestataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prestataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        							<option value="<?php echo e($prestataire->id); ?>"
        								<?php if($prestataire->id==old('prestataire_id') || $prestataire->id==session('new_prestataire_id')): ?> selected
        								<?php endif; ?>>
        								<?php echo e($prestataire->fullname); ?></option>
    								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        						</select>
        						<?php endif; ?>
        					</div>
        					<div class="form-group">
								<label class="" for="montant_prestation_ht">Montant HT</label> 
								<input id="montant_prestation_ht" name="montant_prestation_ht"
									class="form-control form-control-lg<?php echo e($errors->has('montant_prestation_ht') ? ' is-invalid' : ''); ?>" type="number" step="0.01"
									value="<?php echo e(old('montant_prestation_ht')); ?>" />
							</div>
							<div class="form-group">
								<label class="" for="scheduled_at">Programmée le</label> <input id="scheduled_at" name="scheduled_at"
									class="form-control form-control-lg" type="datetime-local"
									<?php if(old('scheduled_at')): ?> 
									value="Carbon\Carbon::createFromFormat('Y-m-d h:i:s',old('scheduled_at'))->format('Y-m-d\TH:i')}}"
									<?php endif; ?> 
									/>
							</div>
        				</fieldset>
						<fieldset>
							<legend>
								<i class="fas fa-coins"></i> Coûts additionnels
							</legend>
							<div class="row">
								<div class="form-group col-12 col-lg-6">
    								<label class="" for="montant_amo_ht">Frais administratifs HT</label> 
    								<input id="montant_amo_ht" name="montant_amo_ht"
    									class="form-control form-control-lg" type="text"
    									value="<?php echo e($montant_amo_ht); ?>" />
    							</div>
    							<div class="form-group col-12 col-lg-6">
    								<label class="" for="montant_dep_ht">Déplacement <?php echo e($demande->adresse->commune->nom); ?> HT</label> 
    								<input readonly disabled id="montant_dep_ht" name="montant_dep_ht"
    									class="form-control form-control-lg" type="number" step="0.01"
    									value="<?php echo e($demande->adresse->commune->tarif); ?>" />
    							</div>
							</div>
						</fieldset>
						<fieldset>
							<legend>
								<i class="fas fa-coins"></i> Acompte
							</legend>
							<div class="row">
								<div class="form-group input-group col-12 col-lg-6">
                                  <input name="pcent_acompte" id="pcent_acompte" type="text" class="form-control text-right<?php echo e($errors->has('pcent_acompte') ? ' is-invalid' : ''); ?>" aria-label="Pourcentage acompte" value="<?php echo e(old('pcent_acompte',50)); ?>">
                                  <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                  </div>
                                </div>
							</div>
						</fieldset>
						<div class="col-12">
							<div class="form-group row">
								<div class="col">
									<a data-toggle="confirmation" data-title="Confirmer?"
										href="<?php echo e(route('demandes.index')); ?>"
										class="btn btn-info pull-right form-group"><?php echo e(__('Cancel')); ?></a>
								</div>
								<div class="col">
									<button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
								</div>
							</div>
						</div>
					</form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('morejs'); ?>
<script>
$("#montant_prestation_ht").on('change', function() {
	$("#montant_amo_ht").val($(this).val()*0.15);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\HelloDjo_Source\resources\views/interventions/create.blade.php ENDPATH**/ ?>