@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><h1><i class="far fa-credit-card"></i> Paiement Uniskip</h1></div>

                <div class="card-body">
                   <div class="panel panel-primary">
						@if(session()->has('warning'))
                            <div class="alert alert-warning }}"> 
                            {!! session('warning') !!}
                            </div>
                        @endif
                        <div class="card">
                        	<div class="card-header">Uniskip</div>
                    		<div class="card-body">
	                    		<form method="POST" action="{{route('paiement.uniskipCB')}}">
	                    		{{csrf_field()}}
	                    		
	                    		Montant : {{$montant}}<br>
	                    		Transaction : {{$transaction_id}}<br>
	                    		</br>
	                    		</form>
	                    		<iframe width="100%" height="800px" src="{{$cblink['url']}}" border="0" style="border:none"></iframe>
                    			<div id="messageTrans" style="" class="text-danger"><i class="fas fa-exclamation-triangle"></i>Enregistrement en cours... Merci de ne pas fermer votre navigateur 
			                    </div>
                    		</div>
                    		
                    	</div>
                    </div>
		        </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('morejs')
 <script>

function ask(canBack=false){
	var jqxhr = $.ajax( {
		type : "GET",
		url : "{{route('uniskipCBVerif',$cblink['demande_id'])}}",
		cache : false,
		dataType : "json" } )
			.done(function(reponse) {
				console.log('!');
				if (reponse['payment'] =='ok'){
					console.log("OK!!!!");
					clearInterval(myVar);
					$('#messageTrans').html('<div class="alert alertToolsBar alert-success">'+
											'Paiement effectué...Votre facture est accessible dans votre espace client. '+
											'<a href="' + reponse['location'] + '" class="btn btn-primary">Continuer</a>'+
											'</div>');
					$("#messageTrans").animate({
			 			top:'-40px',
			 			opacity:'1'
			 			});
				}
	    });
}

var myVar = setInterval(myTimer, 5000);
var temps=0;
function myTimer() {
	temps++;
	console.log(temps);
	ask();
	if (temps>100) {
		clearInterval(myVar);
	}
}
</script>
@endsection
