@extends('layouts.app')
@section('morecss')
<style>
<!--
ul li{list-style:none;margin-bottom:0.5em;}
ul.demandes{margin-left:0;padding-left:0}
ul.demandes li:first-child{font-weight:600}
ul.demandes > li:first-child > a:first-child{font-size:x-large;}
ul.demandes li a.dropdown-toggle,ul ul li {font-size:small}
.dropdown-menu.messages{font-size:small}
.flex-item{width:150px;margin-bottom:2em;align-items: center;
    display: flex;
    justify-content: center;}
.flex-item a{text-align:center;color:#6666aa}
.flex-item a:hover{color:#6666ff}
.flex-item i{width:100%;font-size: 120px}
.text-shadow{text-shadow:0 .5rem 1rem rgba(0,0,0,.15)!important }

-->
.coman-bg{
	background-image:none !important;
}
.pb-4, .py-4 {
    padding-bottom: 0rem!important;
}
.banner{
padding: 85px 0px;
}
.guest-home {
    background-image: url(../image/horizental-img.png);
    padding: 100px 0px 100px 0px;
    margin-top: 30px;
    background-repeat: no-repeat;
    background-size: cover;
    background-position: top;
}
.request{
	text-align: center;
    padding: 35px 0px;
}
.scroll-request{
	height: 375px;
    overflow-y: auto;
}
</style>
@endsection
@section('content')
<div class="banner">
         <div class="container">
            <div class="row">
               <div class="col-12">
                  <div class="banner-text">
                     <h1>Tableau de bord</h1>
                     <div class="banner-col-text-row d-flex">
                        <div class="banner-text-col-img">
                           <img src="{{asset('image/PersonnageMecanicien.png')}}">
                        </div>
                        <div class="banner-text-col-text">
						@if (Auth::user()->prestataire)
                    <h6>Connecté en tant qu'prestataire</h6>
                    @endif
					@if (Auth::user()->admin)
                        <h6>Connecté en tant qu'admin</h6>
						@endif
                           <h2>Tableau de bord</h2>
                        </div>
						@if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                @if ($errors->any())
    				<ul class="alert alert-warning">
    					@foreach ($errors->all() as $error)
    					<li>{{$error}}</li> @endforeach
    				</ul>
				@endif 
				@if(session()->has('message'))
    				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                    {!! session('message') !!}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
    			@endif
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
	  @if (Auth::user()->admin)
      <div class="container"  style="margin-top: 7%;">
         <div class="row">
            <div class="col-lg-3 col-sm-3 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('demandes.index')}}">
                     <img src="image/pictodemande.png">
                     <h5 class="mt-3">Demandes</h5>
                  </a>
                </div>
            </div>

            <div class="col-lg-3 col-sm-3 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('interventions.index')}}">
                     <img src="image/Pictodevis.png">
                     <h5 class="mt-3">Devis</h5>
                  </a>
                </div>
            </div>

            <div class="col-lg-3 col-sm-3 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('factures.index')}}">
                     <img src="image/PictoFactures.png">
                     <h5 class="mt-3">Picto Factures</h5>
                  </a>
                </div>
            </div>
			<div class="col-lg-3 col-sm-3 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('clients.index')}}">
                     <img src="image/clients.PNG">
                     <h5 class="mt-3">Clients</h5>
                  </a>
                </div>
            </div>
         </div> 
      </div>

      <div class="assistent-home">

         <div class="container">
         <div class="row pb-100">
            <div class="col-lg-4 col-sm-4 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('prestataires.index')}}">
                     <img src="image/pictoprestataire.png">
                     <h5 class="mt-3 text-white">Prestataires</h5>
                  </a>
                </div>
            </div>

            <div class="col-lg-4 col-sm-4 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('assistants.index')}}">
                     <img src="image/pictoassistants.png">
                     <h5 class="mt-3 text-white">Assistants</h5>
                  </a>
                </div>
            </div>

            <div class="col-lg-4 col-sm-4 col-12">
               <div class="demeandes-col text-center mt-3">
                  <a href="{{route('communes.index')}}">
                     <img src="image/Pictocommunes.png">
                     <h5 class="mt-3 text-white">Communes</h5>
                  </a>
                </div>
            </div>

			</div> 
			@endif
			@if (Auth::user()->assistant)
			<div class="guest-home">
					<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
		<div class="card request scroll-request">
                    	<h2>Connecté en tant qu'assistant</h2>
                    
                    	<h3>Demandes en cours</h3>
                    	<ul class="demandes">@foreach($demandes as $demande)
                    	<li>{{$demande->created_at_date}} à {{$demande->created_at_time}} : 
                    			<a href="{{route('demandes.show',$demande->id)}}">{{$demande->libelle}}</a> 
                    			par {{$demande->user->fullname}} 
                    	@if (count($demande->messages)) 
            				<a class="dropdown-toggle" data-toggle="dropdown" href="#">({{count($demande->messages)}} messages dont {{count($demande->messages->where('lu','=',null))}} non lus)
            				<span class="caret"></span></a>
                    		<div class="dropdown-menu messages">
                        	@foreach($demande->messages->where('lu','=',null) as $message)
    							<a class="dropdown-item" href="{{route('demandes.show',$demande->id)}}#{{$message->id}}">le {{$message->created_at_date}} à {{$message->created_at_time}} par {{$message->user->fullname}}</a>
                        	@endforeach
                	    	</div>
                    	
                    	@endif
                    	</li>
                    	@endforeach
                    	</ul>
</div>
</div>
</div>
</div>
                	@endif
                	@if (Auth::user()->prestataire)
					<div class="guest-home">
					<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
		<div class="card request">
                    	<h2>Mes interventions programmées</h2>
                    	<ul class="demandes">
                    	@foreach($demandes as $intervention)
                    		<li><a href="{{route('interventions.show',$intervention->id)}}">{{$intervention->demande->libelle}}</a> 
                    		@if ($intervention->scheduled_at)
                    		<small>programmée le {{\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $intervention->scheduled_at)->isoFormat('LLLL')}} </small>
                    		@endif
                    		</li>
                    	@endforeach
                    	</ul>
</div>
</div>
</div>
</div>
</div>
                    @endif
                    
                    @if (!(Auth::user()->admin || Auth::user()->assistant || Auth::user()->prestataire))
					<div class="guest-home">
					<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
		<div class="card request">
                    	<h2><a href="{{route('demandes.create')}}" class="btn btn-click btn-lg font-weight-bold bg-warning  "><i class="fas fa-comment"></i> <span class="">Faire une demande d'intervention</span></a></h2>
                    	@if (count($demandes))
                        	<h3>Mes demandes</h3>
                        	<ul class="demandes">
                        	@foreach($demandes as $demande)
                        	<li>{{$demande->created_at_date}} à {{$demande->created_at_time}} : 
                        			<a href="{{route('demandes.show',$demande->id)}}">{{$demande->libelle}}</a> 
                        			par {{$demande->user->fullname}} 
                			@if (count($demande->messages)) 
                				<a class="dropdown-toggle" data-toggle="dropdown" href="#">({{count($demande->messages)}} messages dont {{count($demande->messages->where('lu','=',null))}} non lus)
                				<span class="caret"></span></a>
                        		<div class="dropdown-menu messages">
                            	@foreach($demande->messages->where('lu','=',null) as $message)
        							<a class="dropdown-item" href="{{route('demandes.show',$demande->id)}}#{{$message->id}}">le {{$message->created_at_date}} à {{$message->created_at_time}} par {{$message->user->fullname}}</a>
                            	@endforeach
                    	    	</div>
                        	
                        	@endif
                        	</li>
                        	@endforeach
                        	</ul>
                    	@endif
</div>
</div>
</div>
</div>
</div>
                    @endif
                   @if (count($demandes))
                   <a href="{{route('demandes.index')}}"><button class='btn btn-click'>voir toutes</button></a>
                   @endif
         </div> 
</div>

</div>


@endsection
