<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUniskipfieldsToSocietes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('societes', function (Blueprint $table) {
            $table->string('motdepasse_uniskip')
            ->after('texte_reglementaire')
            ->nullable(true);
            $table->string('email_uniskip')
            ->after('texte_reglementaire')
            ->nullable(true);
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('societes', function (Blueprint $table) {
            $table->dropColumn(['email_uniskip','motdepasse_uniskip']);
        });
    }
}
