<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddModePaiementIdToPaiements extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('paiements', function (Blueprint $table) {
            $table->uuid('mode_paiement_id');
            $table->foreign('mode_paiement_id')
            ->references('id')
            ->on('mode_paiements');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('paiements', function (Blueprint $table) {
            $table->dropForeign('paiements_mode_paiement_id_foreign');
            $table->dropColumn('mode_paiement_id');
        });
    }
}
