<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAdminToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign('users_user_type_id_foreign');
            $table->dropColumn('user_type_id');
            $table->boolean('prestataire')
                  ->after('telephone')
                  ->comment('0: Non; 1: Oui')
                  ->nullable()
                  ->default(false);
            $table->boolean('assistant')
                  ->after('telephone')
                  ->comment('0: Non; 1: Oui')
                  ->nullable()
                  ->default(false);
            $table->boolean('admin')
                  ->after('telephone')
                  ->comment('0: Non; 1: Oui')
                  ->nullable()
                  ->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('prestataire');
			$table->dropColumn('assistant');
			$table->dropColumn('admin');
        });
    }
}
