<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDemandeStatutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('demande_statut', function (Blueprint $table) {
            $table->uuid('demande_id')->index();
            $table->foreign('demande_id')
                  ->references('id')
                  ->on('demandes')
                  ->onDelete('cascade');

            $table->uuid('statut_id')->index();
            $table->foreign('statut_id')
                  ->references('id')
                  ->on('statuts')
                  ->onDelete('cascade');

            $table->primary(['demande_id', 'statut_id'])->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('demande_statut');
    }
}
