<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Societe extends Model
{
    use UsesUuid;
    public $incrementing = false; 
    protected $fillable = ['raison_sociale','enseigne','siret','adresse','code_postal','commune','tarif_prestation_ht','cgv','texte_reglementaire','tva_id','tva_travaux_id'];
    public function tva()
    {
        // Relation 1..n
        return $this->belongsTo(Tva::class);
    }
    public function tva_travaux()
    {
        // Relation 1..n
        return $this->belongsTo(Tva::class,'tva_travaux_id');
    }
}
