<?php namespace App\Repositories;

use App\Demande;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
class DemandeRepository extends BaseRepository
{
	public function __construct(Demande $demande)
	{
		$this->model = $demande;
	}

	public function getById($id)
	{
		return $this->model->with('adresse','user','messages')->findOrFail($id);
	}
	
	public function getPaginate($n,$request=null)
	{
	    DB::connection()->enableQueryLog();
	    if (Auth::user()->assistant=='1' || Auth::user()->admin)
	       $this->model = Demande::whereNotNull('user_id')->orderby('created_at','desc');
        else
            $this->model = auth()->user()->demandes()->orderby('created_at','desc');
        if($request->datedeb)
            $this->model = $this->model->where('created_at','>=',$request->datedeb);
        if($request->datefin)
            $this->model = $this->model->where('created_at','<=',$request->datefin.' 23:59');
        if($request->user)
            $this->model = $this->model->where('user_id','=',$request->user);
                
            //$this->model = $this->model->whereBetween('created_at',[$request->datedeb,$request->datefin]);
	   return $this->model->paginate($n);
	   //dd(DB::connection()->getQueryLog());
	}
}