<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Ligne_demande extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'libelle',
        'montant_ht',
        'taux_tva',
        'tva_id'
    ];

    public function demande()
    {
        // Relation 1..n
        return $this->belongsTo(Demande::class);
    }

    public function tva()
    {
        // Relation 1..n
        return $this->belongsTo(Tva::class);
    }
}
