<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;
use Carbon\Carbon;

class Intervention extends Model
{
    use UsesUuid;
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'descriptif',
        'montant_prestation_ht',
        'scheduled_at',
        'scoring',
        'user_id',
        'demande_id'
    ];

    public function user()
    {
        // Relation 1..n
        return $this->belongsTo(User::class);
    }

    public function demande()
    {
        // Relation 1..n
        return $this->belongsTo(Demande::class);
    }
    
    public function getCreatedAtDateAttribute(){
        return $this->created_at->formatLocalized('%d %B %Y');
    }
    
    public function getScheduledAtDateAttribute(){
        if ($this->scheduled_at)
            return Carbon::createFromFormat('Y-m-d H:i:s', $this->scheduled_at)->formatLocalized('%d %B %Y');
        return '';
    }
    
    /*public function getScheduledAtDateAttribute(){
        if ($this->scheduled_at)
            return $this->scheduled_at->formatLocalized('%d %B %Y');
        return '';
    }*/
    
    public function getScheduledAtTimeAttribute(){
        if ($this->scheduled_at)
            return Carbon::createFromFormat('Y-m-d H:i:s', $this->scheduled_at)->format('H:i');
        return '';
    }
}
