<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UsesUuid;

class Document extends Model
{
    use UsesUuid;
    
    public $incrementing = false; // Pas auto-incrementing!
    protected $fillable = [
        'id',
        'libelle',
        'nom_fichier',
        'url',
        'type_mime',
    ];

    public function messages()
    {
        // Relation n..n
        return $this->belongsToMany(Message::class);
    }
}
